/*
 * Decompiled with CFR 0.152.
 */
package com.upl.digitalmodular.web.rest;

import com.upl.digitalmodular.service.QueryService;
import com.upl.digitalmodular.service.dto.QueryDTO;
import com.upl.digitalmodular.service.utility.I18nUtility;
import com.upl.digitalmodular.web.rest.errors.BadRequestAlertException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.PaginationUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class QueryResource {
    private final Logger log = LoggerFactory.getLogger(QueryResource.class);
    private static final String ENTITY_NAME = "digitalmodularQuery";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final QueryService queryService;
    @Autowired
    private I18nUtility i18nUtility;

    public QueryResource(QueryService queryService) {
        this.queryService = queryService;
    }

    @PostMapping(value={"/queries"})
    public ResponseEntity<QueryDTO> createQuery(@Valid @RequestBody QueryDTO queryDTO) throws URISyntaxException {
        this.log.debug("REST request to save Query : {}", (Object)queryDTO);
        if (queryDTO.getId() != null) {
            String message = this.i18nUtility.getMessage("query.create.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idexists");
        }
        QueryDTO result = this.queryService.save(queryDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/queries/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/queries/{id}"})
    public ResponseEntity<QueryDTO> updateQuery(@PathVariable(value="id", required=false) Long id, @Valid @RequestBody QueryDTO queryDTO) throws URISyntaxException {
        this.log.debug("REST request to update Query : {}, {}", (Object)id, (Object)queryDTO);
        if (queryDTO.getId() == null) {
            String message = this.i18nUtility.getMessage("query.update.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idnull");
        }
        QueryDTO result = this.queryService.save(queryDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)queryDTO.getId().toString()))).body((Object)result);
    }

    @PatchMapping(value={"/queries/{id}"}, consumes={"application/json", "application/merge-patch+json"})
    public ResponseEntity<QueryDTO> partialUpdateQuery(@PathVariable(value="id", required=false) Long id, @NotNull @RequestBody QueryDTO queryDTO) throws URISyntaxException {
        this.log.debug("REST request to partial update Query partially : {}, {}", (Object)id, (Object)queryDTO);
        if (queryDTO.getId() == null) {
            String message = this.i18nUtility.getMessage("query.patch.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idnull");
        }
        Optional result = this.queryService.partialUpdate(queryDTO);
        return ResponseUtil.wrapOrNotFound((Optional)result, (HttpHeaders)HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)queryDTO.getId().toString()));
    }

    @GetMapping(value={"/queries"})
    public ResponseEntity<Page<QueryDTO>> getAllQueries(Pageable pageable) {
        this.log.debug("REST request to get a page of Queries");
        Page page = this.queryService.findAll(pageable);
        HttpHeaders headers = PaginationUtil.generatePaginationHttpHeaders((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequest(), (Page)page);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)page);
    }

    @GetMapping(value={"/queries/{id}"})
    public ResponseEntity<QueryDTO> getQuery(@PathVariable Long id) {
        this.log.debug("REST request to get Query : {}", (Object)id);
        Optional queryDTO = this.queryService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)queryDTO);
    }

    @DeleteMapping(value={"/queries/{id}"})
    public ResponseEntity<Void> deleteQuery(@PathVariable Long id) {
        this.log.debug("REST request to delete Query : {}", (Object)id);
        this.queryService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }

    @PutMapping(value={"/queries/read"})
    public ResponseEntity<Void> readQueries(Long id, @RequestParam Boolean readAll) {
        this.log.debug("REST request to read queries : {}", (Object)id);
        this.queryService.readQueries(id, readAll);
        return ResponseEntity.noContent().build();
    }
}

