/*
 * Decompiled with CFR 0.152.
 */
package com.upl.digitalmodular.web.rest;

import com.upl.digitalmodular.service.ApplicationAccessRequestQueryService;
import com.upl.digitalmodular.service.ApplicationAccessRequestService;
import com.upl.digitalmodular.service.criteria.ApplicationAccessRequestCriteria;
import com.upl.digitalmodular.service.dto.ApplicationAccessRequestDTO;
import com.upl.digitalmodular.service.utility.I18nUtility;
import com.upl.digitalmodular.web.rest.errors.BadRequestAlertException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.PaginationUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class ApplicationAccessRequestResource {
    private final Logger log = LoggerFactory.getLogger(ApplicationAccessRequestResource.class);
    private static final String ENTITY_NAME = "digitalmodularApplicationAccessRequest";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final ApplicationAccessRequestService applicationAccessRequestService;
    private final ApplicationAccessRequestQueryService applicationAccessRequestQueryService;
    @Autowired
    private I18nUtility i18nUtility;

    public ApplicationAccessRequestResource(ApplicationAccessRequestService applicationAccessRequestService, ApplicationAccessRequestQueryService applicationAccessRequestQueryService) {
        this.applicationAccessRequestService = applicationAccessRequestService;
        this.applicationAccessRequestQueryService = applicationAccessRequestQueryService;
    }

    @PostMapping(value={"/application-access-requests"})
    public ResponseEntity<ApplicationAccessRequestDTO> createApplicationAccessRequest(@Valid @RequestBody ApplicationAccessRequestDTO applicationAccessRequestDTO) throws URISyntaxException {
        this.log.debug("REST request to save ApplicationAccessRequest : {}", (Object)applicationAccessRequestDTO);
        if (applicationAccessRequestDTO.getId() != null) {
            String message = this.i18nUtility.getMessage("applicationAccessRequest.create.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idexists");
        }
        ApplicationAccessRequestDTO result = this.applicationAccessRequestService.save(applicationAccessRequestDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/application-access-requests/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/application-access-requests/{id}"})
    public ResponseEntity<ApplicationAccessRequestDTO> updateApplicationAccessRequest(@PathVariable(value="id", required=false) Long id, @Valid @RequestBody ApplicationAccessRequestDTO applicationAccessRequestDTO) throws URISyntaxException {
        this.log.debug("REST request to update ApplicationAccessRequest : {}, {}", (Object)id, (Object)applicationAccessRequestDTO);
        if (applicationAccessRequestDTO.getId() == null) {
            String message = this.i18nUtility.getMessage("applicationAccessRequest.update.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idnull");
        }
        ApplicationAccessRequestDTO result = this.applicationAccessRequestService.save(applicationAccessRequestDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)applicationAccessRequestDTO.getId().toString()))).body((Object)result);
    }

    @PatchMapping(value={"/application-access-requests/{id}"}, consumes={"application/json", "application/merge-patch+json"})
    public ResponseEntity<ApplicationAccessRequestDTO> partialUpdateApplicationAccessRequest(@PathVariable(value="id", required=false) Long id, @NotNull @RequestBody ApplicationAccessRequestDTO applicationAccessRequestDTO) throws URISyntaxException {
        this.log.debug("REST request to partial update ApplicationAccessRequest partially : {}, {}", (Object)id, (Object)applicationAccessRequestDTO);
        if (applicationAccessRequestDTO.getId() == null) {
            String message = this.i18nUtility.getMessage("applicationAccessRequest.patch.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idnull");
        }
        Optional result = this.applicationAccessRequestService.partialUpdate(applicationAccessRequestDTO);
        return ResponseUtil.wrapOrNotFound((Optional)result, (HttpHeaders)HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)applicationAccessRequestDTO.getId().toString()));
    }

    @GetMapping(value={"/application-access-requests"})
    public ResponseEntity<Page<ApplicationAccessRequestDTO>> getAllApplicationAccessRequests(ApplicationAccessRequestCriteria criteria, Pageable pageable) {
        this.log.debug("REST request to get ApplicationAccessRequests by criteria: {}", (Object)criteria);
        Page page = this.applicationAccessRequestQueryService.findByCriteria(criteria, pageable);
        HttpHeaders headers = PaginationUtil.generatePaginationHttpHeaders((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequest(), (Page)page);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)page);
    }

    @GetMapping(value={"/application-access-requests/count"})
    public ResponseEntity<Long> countApplicationAccessRequests(ApplicationAccessRequestCriteria criteria) {
        this.log.debug("REST request to count ApplicationAccessRequests by criteria: {}", (Object)criteria);
        return ResponseEntity.ok().body((Object)this.applicationAccessRequestQueryService.countByCriteria(criteria));
    }

    @GetMapping(value={"/application-access-requests/{id}"})
    public ResponseEntity<ApplicationAccessRequestDTO> getApplicationAccessRequest(@PathVariable Long id) {
        this.log.debug("REST request to get ApplicationAccessRequest : {}", (Object)id);
        Optional applicationAccessRequestDTO = this.applicationAccessRequestService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)applicationAccessRequestDTO);
    }

    @DeleteMapping(value={"/application-access-requests/{id}"})
    public ResponseEntity<Void> deleteApplicationAccessRequest(@PathVariable Long id) {
        this.log.debug("REST request to delete ApplicationAccessRequest : {}", (Object)id);
        this.applicationAccessRequestService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }

    @GetMapping(value={"/application-access-requests/checkRequest"})
    public Boolean checkRequest(@RequestParam(value="userId", required=true) Long userId, @RequestParam(value="appId", required=true) Long applicationId) {
        return this.applicationAccessRequestService.checkApplicationRequest(userId, applicationId);
    }
}

