/*
 * Decompiled with CFR 0.152.
 */
package com.upl.digitalmodular.web.rest;

import com.upl.digitalmodular.service.AppUserApplicationAccessQueryService;
import com.upl.digitalmodular.service.AppUserApplicationAccessService;
import com.upl.digitalmodular.service.criteria.AppUserApplicationAccessCriteria;
import com.upl.digitalmodular.service.dto.AppUserApplicationAccessDTO;
import com.upl.digitalmodular.service.utility.I18nUtility;
import com.upl.digitalmodular.web.rest.errors.BadRequestAlertException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class AppUserApplicationAccessResource {
    private final Logger log = LoggerFactory.getLogger(AppUserApplicationAccessResource.class);
    private static final String ENTITY_NAME = "digitalmodularAppUserApplicationAccess";
    @Autowired
    private I18nUtility i18nUtility;
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final AppUserApplicationAccessService appUserApplicationAccessService;
    private final AppUserApplicationAccessQueryService appUserApplicationAccessQueryService;

    public AppUserApplicationAccessResource(AppUserApplicationAccessService appUserApplicationAccessService, AppUserApplicationAccessQueryService appUserApplicationAccessQueryService) {
        this.appUserApplicationAccessService = appUserApplicationAccessService;
        this.appUserApplicationAccessQueryService = appUserApplicationAccessQueryService;
    }

    @PostMapping(value={"/app-user-application-accesses"})
    @PreAuthorize(value="hasAnyAuthority(\"ADMIN\")")
    public ResponseEntity<AppUserApplicationAccessDTO> createAppUserApplicationAccess(@RequestBody AppUserApplicationAccessDTO appUserApplicationAccessDTO) throws URISyntaxException {
        this.log.debug("REST request to save AppUserApplicationAccess : {}", (Object)appUserApplicationAccessDTO);
        if (appUserApplicationAccessDTO.getId() != null) {
            String message = this.i18nUtility.getMessage("appUserApplicationAccess.create.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idexists");
        }
        AppUserApplicationAccessDTO result = this.appUserApplicationAccessService.save(appUserApplicationAccessDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/app-user-application-accesses/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/app-user-application-accesses/{id}"})
    public ResponseEntity<AppUserApplicationAccessDTO> updateAppUserApplicationAccess(@PathVariable(value="id", required=false) Long id, @RequestBody AppUserApplicationAccessDTO appUserApplicationAccessDTO) throws URISyntaxException {
        this.log.debug("REST request to update AppUserApplicationAccess : {}, {}", (Object)id, (Object)appUserApplicationAccessDTO);
        if (appUserApplicationAccessDTO.getId() == null) {
            String message = this.i18nUtility.getMessage("appUserApplicationAccess.update.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idnull");
        }
        AppUserApplicationAccessDTO result = this.appUserApplicationAccessService.save(appUserApplicationAccessDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)appUserApplicationAccessDTO.getId().toString()))).body((Object)result);
    }

    @PatchMapping(value={"/app-user-application-accesses/{id}"}, consumes={"application/json", "application/merge-patch+json"})
    public ResponseEntity<AppUserApplicationAccessDTO> partialUpdateAppUserApplicationAccess(@PathVariable(value="id", required=false) Long id, @RequestBody AppUserApplicationAccessDTO appUserApplicationAccessDTO) throws URISyntaxException {
        this.log.debug("REST request to partial update AppUserApplicationAccess partially : {}, {}", (Object)id, (Object)appUserApplicationAccessDTO);
        if (appUserApplicationAccessDTO.getId() == null) {
            String message = this.i18nUtility.getMessage("appUserApplicationAccess.patch.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idnull");
        }
        Optional result = this.appUserApplicationAccessService.partialUpdate(appUserApplicationAccessDTO);
        return ResponseUtil.wrapOrNotFound((Optional)result, (HttpHeaders)HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)appUserApplicationAccessDTO.getId().toString()));
    }

    @GetMapping(value={"/app-user-application-accesses"})
    public ResponseEntity<Page<AppUserApplicationAccessDTO>> getAllAppUserApplicationAccesses(AppUserApplicationAccessCriteria criteria, Pageable pageable) {
        this.log.debug("REST request to get AppUserApplicationsAccess by criteria: {}", (Object)criteria);
        Page entityList = this.appUserApplicationAccessQueryService.findByCriteria(criteria, pageable);
        return ResponseEntity.ok().body((Object)entityList);
    }

    @GetMapping(value={"/app-user-application-accesses/{id}"})
    public ResponseEntity<AppUserApplicationAccessDTO> getAppUserApplicationAccess(@PathVariable Long id) {
        this.log.debug("REST request to get AppUserApplicationAccess : {}", (Object)id);
        Optional appUserApplicationAccessDTO = this.appUserApplicationAccessService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)appUserApplicationAccessDTO);
    }

    @DeleteMapping(value={"/app-user-application-accesses/{id}"})
    public ResponseEntity<Void> deleteAppUserApplicationAccess(@PathVariable Long id) {
        this.log.debug("REST request to delete AppUserApplicationAccess : {}", (Object)id);
        this.appUserApplicationAccessService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }

    @DeleteMapping(value={"/app-user-application-accesses/deleteAccess/{id}"})
    public ResponseEntity<Void> deleteApplicationAccess(@PathVariable Long id) {
        this.log.debug("REST request to delete ApplicationAccess : {}", (Object)id);
        this.appUserApplicationAccessService.deleteApplicationUser(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }

    @DeleteMapping(value={"/app-user-application-accesses/disable"})
    public ResponseEntity<Void> disableApplicationAccess(@RequestParam Long id, @RequestParam(value="ids", required=true) List<Long> ids) {
        this.log.debug("REST request to delete user ApplicationAccess : {}", (Object)id);
        this.appUserApplicationAccessService.disableApplications(id, ids);
        return ResponseEntity.noContent().build();
    }
}

