/*
 * Decompiled with CFR 0.152.
 */
package com.upl.digitalmodular.service.impl;

import com.upl.digitalmodular.domain.Notification;
import com.upl.digitalmodular.domain.enumeration.Category;
import com.upl.digitalmodular.repository.ApplicationAccessRequestRepository;
import com.upl.digitalmodular.repository.NotificationRepository;
import com.upl.digitalmodular.security.SecurityUtils;
import com.upl.digitalmodular.service.NotificationService;
import com.upl.digitalmodular.service.dto.NotificationDTO;
import com.upl.digitalmodular.service.exception.BadRequestException;
import com.upl.digitalmodular.service.mapper.NotificationMapper;
import com.upl.digitalmodular.service.utility.I18nUtility;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class NotificationServiceImpl
implements NotificationService {
    private final Logger log = LoggerFactory.getLogger(NotificationServiceImpl.class);
    private final NotificationRepository notificationRepository;
    private final NotificationMapper notificationMapper;
    @Autowired
    private I18nUtility i18nUtility;

    public NotificationServiceImpl(NotificationRepository notificationRepository, NotificationMapper notificationMapper, ApplicationAccessRequestRepository applicationAccessRequestRepository) {
        this.notificationRepository = notificationRepository;
        this.notificationMapper = notificationMapper;
    }

    public NotificationDTO save(NotificationDTO notificationDTO) {
        this.log.debug("Request to save Notification : {}", (Object)notificationDTO);
        Notification notification = (Notification)this.notificationMapper.toEntity((Object)notificationDTO);
        notification = (Notification)this.notificationRepository.save((Object)notification);
        return this.notificationMapper.toDto(notification);
    }

    public Optional<NotificationDTO> partialUpdate(NotificationDTO notificationDTO) {
        this.log.debug("Request to partially update Notification : {}", (Object)notificationDTO);
        return this.notificationRepository.findById((Object)notificationDTO.getId()).map(existingNotification -> {
            this.notificationMapper.partialUpdate(existingNotification, (Object)notificationDTO);
            return existingNotification;
        }).map(arg_0 -> ((NotificationRepository)this.notificationRepository).save(arg_0)).map(arg_0 -> ((NotificationMapper)this.notificationMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public Page<NotificationDTO> findAll(Pageable pageable) {
        this.log.debug("Request to get all Notifications");
        return this.notificationRepository.findAll(pageable).map(arg_0 -> ((NotificationMapper)this.notificationMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public Optional<NotificationDTO> findOne(Long id) {
        this.log.debug("Request to get Notification : {}", (Object)id);
        if (!this.notificationRepository.existsById((Object)id)) {
            String message = this.i18nUtility.getMessage("notificationRepository.get.entity.exception", null);
            throw new BadRequestException(message);
        }
        return this.notificationRepository.findById((Object)id).map(arg_0 -> ((NotificationMapper)this.notificationMapper).toDto(arg_0));
    }

    public void delete(Long id) {
        this.log.debug("Request to delete Notification : {}", (Object)id);
        Optional notification = this.notificationRepository.findById((Object)id);
        if (!notification.isPresent()) {
            String message = this.i18nUtility.getMessage("notificationRepository.delete.id.exception", null);
            throw new BadRequestException(message);
        }
        ((Notification)notification.get()).setStatus(Boolean.valueOf(false));
        this.notificationRepository.save((Object)((Notification)notification.get()));
    }

    public void readNotification(Long id, Boolean readAll, Integer category) {
        List notifications;
        this.log.debug("Rest request to read notification");
        Long loggedInUser = Long.parseLong((String)SecurityUtils.getCurrentUserLogin().get());
        if (category == 1 && readAll.booleanValue()) {
            notifications = this.notificationRepository.findByCategoryIs(Category.QUERIES);
            for (Notification notification : notifications) {
                notification.setReadStatus(Boolean.valueOf(true));
                notification.setReadAt(Instant.now());
                this.notificationRepository.save((Object)notification);
            }
        }
        if (category == 2 && readAll.booleanValue()) {
            notifications = this.notificationRepository.findByAppUserIdIsNullAndCategoryIs(Category.NOTICE);
            for (Notification notification : notifications) {
                notification.setReadStatus(Boolean.valueOf(true));
                notification.setReadAt(Instant.now());
                this.notificationRepository.save((Object)notification);
            }
        }
        if (readAll.booleanValue() && category == 3) {
            notifications = this.notificationRepository.findByAppUserIdAndCategoryIs(loggedInUser, Category.NOTICE);
            for (Notification notification : notifications) {
                notification.setReadStatus(Boolean.valueOf(true));
                notification.setReadAt(Instant.now());
                this.notificationRepository.save((Object)notification);
            }
        }
    }

    public void readOneNotification(Long id) {
        this.log.debug("Rest request to read notification");
        Notification changeNotificationStatus = (Notification)this.notificationRepository.findById((Object)id).get();
        changeNotificationStatus.setReadStatus(Boolean.valueOf(true));
        changeNotificationStatus.setReadAt(Instant.now());
        this.notificationRepository.save((Object)changeNotificationStatus);
    }

    public Integer countNotificationAdmin() {
        Long queryCount = this.notificationRepository.countByReadStatusIsFalseAndStatusIsTrueAndCategoryIs(Category.QUERIES);
        Long requestCount = this.notificationRepository.countByReadStatusIsFalseAndStatusIsTrueAndCategoryIs(Category.REQUESTACCESS);
        Long noticeCount = this.notificationRepository.countByAppUserIdIsNullAndReadStatusIsFalseAndCategoryIs(Category.NOTICE);
        Integer intQueryVal = queryCount == null ? null : Integer.valueOf(Math.toIntExact(queryCount));
        Integer intNoticeVal = noticeCount == null ? null : Integer.valueOf(Math.toIntExact(noticeCount));
        Integer intRequestVal = requestCount == null ? null : Integer.valueOf(Math.toIntExact(requestCount));
        Integer totalCount = intQueryVal + intNoticeVal + intRequestVal;
        return totalCount;
    }
}

