/*
 * Decompiled with CFR 0.152.
 */
package com.upl.digitalmodular.service.impl;

import com.upl.digitalmodular.domain.AppUserApplicationAccess;
import com.upl.digitalmodular.domain.Application;
import com.upl.digitalmodular.repository.ApplicationRepository;
import com.upl.digitalmodular.service.AppUserApplicationAccessService;
import com.upl.digitalmodular.service.ApplicationQueryService;
import com.upl.digitalmodular.service.ApplicationService;
import com.upl.digitalmodular.service.criteria.ApplicationCriteria;
import com.upl.digitalmodular.service.dto.ApplicationDTO;
import com.upl.digitalmodular.service.exception.BadRequestException;
import com.upl.digitalmodular.service.mapper.ApplicationMapper;
import com.upl.digitalmodular.service.utility.AmazonUtility;
import com.upl.digitalmodular.service.utility.I18nUtility;
import com.upl.digitalmodular.service.utility.ImageUtility;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import tech.jhipster.service.filter.LongFilter;

@Service
@Transactional
public class ApplicationServiceImpl
implements ApplicationService {
    private final Logger log = LoggerFactory.getLogger(ApplicationServiceImpl.class);
    private final ApplicationRepository applicationRepository;
    private final ApplicationMapper applicationMapper;
    private final AmazonUtility amazonUtility;
    private final AppUserApplicationAccessService appUserApplicationAccessService;
    private final ApplicationQueryService applicationQueryService;
    private static final String UPLOAD_LOGO_DIRECTORY = "applicationlogos";
    @Value(value="${application.allowed-image-content-types:}")
    private String allowedImageContentTypes;
    @Autowired
    private I18nUtility i18nUtility;
    @Autowired
    private ImageUtility imageUtility;

    public ApplicationServiceImpl(ApplicationRepository applicationRepository, ApplicationMapper applicationMapper, AmazonUtility amazonUtility, AppUserApplicationAccessService appUserApplicationAccessService, ApplicationQueryService applicationQueryService) {
        this.applicationRepository = applicationRepository;
        this.applicationMapper = applicationMapper;
        this.amazonUtility = amazonUtility;
        this.appUserApplicationAccessService = appUserApplicationAccessService;
        this.applicationQueryService = applicationQueryService;
    }

    public ApplicationDTO save(ApplicationDTO applicationDTO) {
        this.log.debug("Request to save Application : {}", (Object)applicationDTO);
        if (applicationDTO.getId() == null) {
            applicationDTO.setStatus(Boolean.valueOf(true));
        }
        Application application = this.applicationMapper.toEntity(applicationDTO);
        application = (Application)this.applicationRepository.save((Object)application);
        return this.applicationMapper.toDto(application);
    }

    public Optional<ApplicationDTO> partialUpdate(ApplicationDTO applicationDTO) {
        this.log.debug("Request to partially update Application : {}", (Object)applicationDTO);
        return this.applicationRepository.findById((Object)applicationDTO.getId()).map(existingApplication -> {
            this.applicationMapper.partialUpdate(existingApplication, (Object)applicationDTO);
            return existingApplication;
        }).map(arg_0 -> ((ApplicationRepository)this.applicationRepository).save(arg_0)).map(arg_0 -> ((ApplicationMapper)this.applicationMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public List<ApplicationDTO> findAll() {
        this.log.debug("Request to get all Applications");
        return this.applicationRepository.findAllWithEagerRelationships().stream().map(arg_0 -> ((ApplicationMapper)this.applicationMapper).toDto(arg_0)).collect(Collectors.toCollection(LinkedList::new));
    }

    public Page<ApplicationDTO> findAllWithEagerRelationships(Pageable pageable) {
        return this.applicationRepository.findAllWithEagerRelationships(pageable).map(arg_0 -> ((ApplicationMapper)this.applicationMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public Optional<ApplicationDTO> findOne(Long id) {
        this.log.debug("Request to get Application : {}", (Object)id);
        if (!this.applicationRepository.existsById((Object)id)) {
            String message = this.i18nUtility.getMessage("applicationRepository.get.entity.exception", null);
            throw new BadRequestException(message);
        }
        return this.applicationRepository.findOneWithEagerRelationships(id).map(arg_0 -> ((ApplicationMapper)this.applicationMapper).toDto(arg_0));
    }

    public void delete(Long id) {
        this.log.debug("Request to delete Application : {}", (Object)id);
        Optional application = this.applicationRepository.findById((Object)id);
        if (!application.isPresent()) {
            String message = this.i18nUtility.getMessage("applicationRepository.delete.id.exception", null);
            throw new BadRequestException(message);
        }
        ((Application)application.get()).setStatus(Boolean.valueOf(false));
        this.applicationRepository.save((Object)((Application)application.get()));
    }

    public String uploadApplicationLogo(MultipartFile file) throws IOException {
        this.log.debug("Request to upload application logo with image : {}", (Object)file.getOriginalFilename());
        String[] elements = this.allowedImageContentTypes.split(",");
        List<String> allowedTypes = Arrays.asList(elements);
        if (allowedTypes.contains(file.getContentType())) {
            this.imageUtility.validateImage(file);
            String applicationLogoUrl = this.amazonUtility.uploadFile(file, UPLOAD_LOGO_DIRECTORY);
            return applicationLogoUrl;
        }
        String message = this.i18nUtility.getMessage("application.upload.logo.exception", null);
        throw new BadRequestException(message);
    }

    @Transactional(readOnly=true)
    public List<Application> assignedApplication(Long id) {
        List<Application> appsAssigned = this.appUserApplicationAccessService.findUserApplications(id).stream().map(AppUserApplicationAccess::getApplication).collect(Collectors.toList());
        return appsAssigned;
    }

    @Transactional(readOnly=true)
    public Page<ApplicationDTO> findAssignedApplications(Long id, ApplicationCriteria criteria, Pageable pageable) {
        List appsAssigned = this.assignedApplication(id);
        List applicationIds = appsAssigned.stream().map(Application::getId).collect(Collectors.toList());
        LongFilter apps = new LongFilter();
        apps.setIn(applicationIds);
        criteria.setId(apps);
        return this.applicationQueryService.findByCriteria(criteria, pageable);
    }

    @Transactional(readOnly=true)
    public Page<ApplicationDTO> findNonAssignedApplications(Long userId, ApplicationCriteria criteria, Pageable pageable) {
        List assigned = this.assignedApplication(userId);
        List allApplications = this.applicationRepository.findByStatusTrue();
        List appsNonAssignedId = allApplications.stream().filter(apps -> !assigned.contains(apps)).map(Application::getId).collect(Collectors.toList());
        LongFilter apps2 = new LongFilter();
        apps2.setIn(appsNonAssignedId);
        criteria.setId(apps2);
        return this.applicationQueryService.findByCriteria(criteria, pageable);
    }

    public ApplicationDTO checkApplicationExist(@Valid ApplicationDTO applicationDTO) {
        if (this.applicationRepository.findByName(applicationDTO.getName()) != null) {
            String message = this.i18nUtility.getMessage("applicationRepository.create.application.name.exception", null);
            throw new BadRequestException(message);
        }
        if (this.applicationRepository.findByTitle(applicationDTO.getTitle()) != null) {
            String message = this.i18nUtility.getMessage("applicationRepository.create.application.title.exception", null);
            throw new BadRequestException(message);
        }
        if (this.applicationRepository.findByApplicationUrl(applicationDTO.getApplicationUrl()) != null) {
            String message = this.i18nUtility.getMessage("applicationRepository.create.application.applicationUrl.exception", null);
            throw new BadRequestException(message);
        }
        if (this.applicationRepository.findByApplicationApiUrl(applicationDTO.getApplicationApiUrl()) != null) {
            String message = this.i18nUtility.getMessage("applicationRepository.create.application.applicationApiUrl.exception", null);
            throw new BadRequestException(message);
        }
        return applicationDTO;
    }

    public void updateCheckApplicationExist(@Valid ApplicationDTO applicationDTO, Long id) {
        Optional app = this.applicationRepository.findByIdNotAndName(applicationDTO.getId(), applicationDTO.getName());
        if (app.isPresent()) {
            String message = this.i18nUtility.getMessage("applicationRepository.create.application.name.exception", null);
            throw new BadRequestException(message);
        }
    }
}

