/*
 * Decompiled with CFR 0.152.
 */
package com.upl.digitalmodular.service.impl;

import com.upl.digitalmodular.domain.AppUser;
import com.upl.digitalmodular.repository.AppUserRepository;
import com.upl.digitalmodular.repository.ApplicationRepository;
import com.upl.digitalmodular.service.AppUserService;
import com.upl.digitalmodular.service.dto.AppUserDTO;
import com.upl.digitalmodular.service.exception.BadRequestException;
import com.upl.digitalmodular.service.mapper.AppUserMapper;
import com.upl.digitalmodular.service.utility.AmazonUtility;
import com.upl.digitalmodular.service.utility.I18nUtility;
import com.upl.digitalmodular.service.utility.ImageUtility;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional
public class AppUserServiceImpl
implements AppUserService {
    private final Logger log = LoggerFactory.getLogger(AppUserServiceImpl.class);
    private final AppUserRepository appUserRepository;
    private final ApplicationRepository applicationRepository;
    private final AppUserMapper appUserMapper;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private I18nUtility i18nUtility;
    private static final String UPLOAD_DIRECTORY = "appUsers";
    @Value(value="${application.allowed-image-content-types:}")
    private String allowedImageContentTypes;
    @Autowired
    private AmazonUtility amazonUtility;
    @Autowired
    private ImageUtility imageUtility;

    public AppUserServiceImpl(AppUserRepository appUserRepository, AppUserMapper appUserMapper, ApplicationRepository applicationRepository) {
        this.appUserRepository = appUserRepository;
        this.applicationRepository = applicationRepository;
        this.appUserMapper = appUserMapper;
    }

    public AppUserDTO save(AppUserDTO appUserDTO) {
        Optional appUserExistWithEmail;
        this.log.debug("Request to save AppUser : {}", (Object)appUserDTO);
        if (appUserDTO.getEmail() != null && (appUserExistWithEmail = this.appUserRepository.findByEmail(appUserDTO.getEmail())).isPresent() && !((AppUser)appUserExistWithEmail.get()).getId().equals(appUserDTO.getId())) {
            this.log.debug("User already exist with email.");
            String message = this.i18nUtility.getMessage("appuser.save.email.exception", null);
            throw new BadRequestException(message);
        }
        Optional appUserExistWithMobile = this.appUserRepository.findByMobileNumber(appUserDTO.getMobileNumber());
        if (appUserExistWithMobile.isPresent() && !((AppUser)appUserExistWithMobile.get()).getId().equals(appUserDTO.getId())) {
            this.log.debug("User already exist with mobile number.");
            String message = this.i18nUtility.getMessage("appuser.save.mobile.number.exception", null);
            throw new BadRequestException(message);
        }
        AppUser appUser = this.appUserMapper.toEntity(appUserDTO);
        this.log.debug("encode user password");
        if (appUser.getId() == null) {
            appUser.setPassword(this.passwordEncoder.encode((CharSequence)appUser.getPassword()));
        } else {
            Optional existingUser = this.appUserRepository.findById((Object)appUser.getId());
            if (existingUser.isPresent()) {
                appUser.setPassword(((AppUser)existingUser.get()).getPassword());
            } else {
                appUser.setPassword(this.passwordEncoder.encode((CharSequence)appUser.getPassword()));
            }
        }
        appUser = (AppUser)this.appUserRepository.save((Object)appUser);
        return this.appUserMapper.toDto(appUser);
    }

    public Optional<AppUserDTO> partialUpdate(AppUserDTO appUserDTO) {
        this.log.debug("Request to partially update AppUser : {}", (Object)appUserDTO);
        return this.appUserRepository.findById((Object)appUserDTO.getId()).map(existingAppUser -> {
            this.appUserMapper.partialUpdate(existingAppUser, (Object)appUserDTO);
            return existingAppUser;
        }).map(arg_0 -> ((AppUserRepository)this.appUserRepository).save(arg_0)).map(arg_0 -> ((AppUserMapper)this.appUserMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public Page<AppUserDTO> findAll(Pageable pageable) {
        this.log.debug("Request to get all AppUsers");
        return this.appUserRepository.findAll(pageable).map(arg_0 -> ((AppUserMapper)this.appUserMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public Optional<AppUserDTO> findOne(Long id) {
        this.log.debug("Request to get AppUser : {}", (Object)id);
        if (!this.appUserRepository.existsById((Object)id)) {
            String message = this.i18nUtility.getMessage("appUserRepository.get.entity.exception", null);
            throw new BadRequestException(message);
        }
        return this.appUserRepository.findById((Object)id).map(arg_0 -> ((AppUserMapper)this.appUserMapper).toDto(arg_0));
    }

    public void delete(Long id) {
        this.log.debug("Request to delete AppUser : {}", (Object)id);
        Optional appUser = this.appUserRepository.findById((Object)id);
        if (!appUser.isPresent()) {
            String message = this.i18nUtility.getMessage("appUserRepository.delete.id.exception", null);
            throw new BadRequestException(message);
        }
        ((AppUser)appUser.get()).setStatus(Boolean.valueOf(false));
        this.appUserRepository.save((Object)((AppUser)appUser.get()));
    }

    public AppUserDTO uploadAndSaveProfileImage(Long id, MultipartFile file) throws IOException {
        String[] elements = this.allowedImageContentTypes.split(",");
        List<String> allowedTypes = Arrays.asList(elements);
        if (allowedTypes.contains(file.getContentType())) {
            this.imageUtility.validateImage(file);
            Optional appUser = this.appUserRepository.findById((Object)id);
            if (StringUtils.isNotBlank((CharSequence)((AppUser)appUser.get()).getProfilePhotoPath())) {
                this.amazonUtility.deleteFileFromS3Bucket(((AppUser)appUser.get()).getProfilePhotoPath());
            }
            String url = this.amazonUtility.uploadFile(file, "appUsers/" + id);
            ((AppUser)appUser.get()).setProfilePhotoPath(url);
            AppUser savedAppUser = (AppUser)this.appUserRepository.save((Object)((AppUser)appUser.get()));
            return this.appUserMapper.toDto(savedAppUser);
        }
        String message = this.i18nUtility.getMessage("appuser.upload.image.exception", null);
        throw new BadRequestException(message);
    }
}

