/*
 * Decompiled with CFR 0.152.
 */
package com.upl.digitalmodular.service.impl;

import com.upl.digitalmodular.domain.AppUserLogin;
import com.upl.digitalmodular.repository.AppUserLoginRepository;
import com.upl.digitalmodular.service.AppUserLoginService;
import com.upl.digitalmodular.service.dto.AppUserLoginDTO;
import com.upl.digitalmodular.service.exception.BadRequestException;
import com.upl.digitalmodular.service.mapper.AppUserLoginMapper;
import com.upl.digitalmodular.service.utility.I18nUtility;
import java.time.Instant;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AppUserLoginServiceImpl
implements AppUserLoginService {
    private final Logger log = LoggerFactory.getLogger(AppUserLoginServiceImpl.class);
    private final AppUserLoginRepository appUserLoginRepository;
    private final AppUserLoginMapper appUserLoginMapper;
    @Autowired
    private I18nUtility i18nUtility;

    public AppUserLoginServiceImpl(AppUserLoginRepository appUserLoginRepository, AppUserLoginMapper appUserLoginMapper) {
        this.appUserLoginRepository = appUserLoginRepository;
        this.appUserLoginMapper = appUserLoginMapper;
    }

    public AppUserLoginDTO save(AppUserLoginDTO appUserLoginDTO) {
        this.log.debug("Request to save AppUserLogin : {}", (Object)appUserLoginDTO);
        AppUserLogin appUserLogin = (AppUserLogin)this.appUserLoginMapper.toEntity((Object)appUserLoginDTO);
        appUserLogin = (AppUserLogin)this.appUserLoginRepository.save((Object)appUserLogin);
        return this.appUserLoginMapper.toDto(appUserLogin);
    }

    public Optional<AppUserLoginDTO> partialUpdate(AppUserLoginDTO appUserLoginDTO) {
        this.log.debug("Request to partially update AppUserLogin : {}", (Object)appUserLoginDTO);
        return this.appUserLoginRepository.findById((Object)appUserLoginDTO.getId()).map(existingAppUserLogin -> {
            this.appUserLoginMapper.partialUpdate(existingAppUserLogin, (Object)appUserLoginDTO);
            return existingAppUserLogin;
        }).map(arg_0 -> ((AppUserLoginRepository)this.appUserLoginRepository).save(arg_0)).map(arg_0 -> ((AppUserLoginMapper)this.appUserLoginMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public List<AppUserLoginDTO> findAll() {
        this.log.debug("Request to get all AppUserLogins");
        return this.appUserLoginRepository.findAll().stream().map(arg_0 -> ((AppUserLoginMapper)this.appUserLoginMapper).toDto(arg_0)).collect(Collectors.toCollection(LinkedList::new));
    }

    @Transactional(readOnly=true)
    public Optional<AppUserLoginDTO> findOne(Long id) {
        this.log.debug("Request to get AppUserLogin : {}", (Object)id);
        if (!this.appUserLoginRepository.existsById((Object)id)) {
            String message = this.i18nUtility.getMessage("appUserLoginRepository.get.entity.exception", null);
            throw new BadRequestException(message);
        }
        return this.appUserLoginRepository.findById((Object)id).map(arg_0 -> ((AppUserLoginMapper)this.appUserLoginMapper).toDto(arg_0));
    }

    public void delete(Long id) {
        this.log.debug("Request to delete AppUserLogin : {}", (Object)id);
        Optional appUserLogin = this.appUserLoginRepository.findById((Object)id);
        if (!appUserLogin.isPresent()) {
            String message = this.i18nUtility.getMessage("appUserLoginRepository.delete.id.exception", null);
            throw new BadRequestException(message);
        }
        ((AppUserLogin)appUserLogin.get()).setLogoutDate(Instant.now());
        this.appUserLoginRepository.save((Object)((AppUserLogin)appUserLogin.get()));
    }
}

