/*
 * Decompiled with CFR 0.152.
 */
package com.upl.digitalmodular.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.upl.digitalmodular.domain.AbstractAuditingEntity;
import com.upl.digitalmodular.domain.AppUser;
import com.upl.digitalmodular.domain.Application;
import com.upl.digitalmodular.domain.enumeration.Category;
import java.io.Serializable;
import java.time.Instant;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Table(name="notifications")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class Notification
extends AbstractAuditingEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    private Long id;
    @Column(name="name")
    private String name;
    @Lob
    @Column(name="description")
    private String description;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    @Column(name="category", nullable=false)
    private Category category;
    @Column(name="expires")
    private Instant expires;
    @Column(name="read_status")
    private Boolean readStatus;
    @Column(name="read_at")
    private Instant readAt;
    @Column(name="status")
    private Boolean status;
    @ManyToOne
    @JsonIgnoreProperties(value={"country", "state"}, allowSetters=true)
    private AppUser appUser;
    @ManyToOne
    @JsonIgnoreProperties(value={"applicationRoles"}, allowSetters=true)
    private Application application;

    public Long getId() {
        return this.id;
    }

    public Notification id(Long id) {
        this.setId(id);
        return this;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public Notification name(String name) {
        this.setName(name);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public Notification description(String description) {
        this.setDescription(description);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Category getCategory() {
        return this.category;
    }

    public Notification category(Category category) {
        this.setCategory(category);
        return this;
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    public Instant getExpires() {
        return this.expires;
    }

    public Notification expires(Instant expires) {
        this.setExpires(expires);
        return this;
    }

    public void setExpires(Instant expires) {
        this.expires = expires;
    }

    public Boolean getReadStatus() {
        return this.readStatus;
    }

    public Notification readStatus(Boolean readStatus) {
        this.setReadStatus(readStatus);
        return this;
    }

    public void setReadStatus(Boolean readStatus) {
        this.readStatus = readStatus;
    }

    public Instant getReadAt() {
        return this.readAt;
    }

    public Notification readAt(Instant readAt) {
        this.setReadAt(readAt);
        return this;
    }

    public void setReadAt(Instant readAt) {
        this.readAt = readAt;
    }

    public Boolean getStatus() {
        return this.status;
    }

    public Notification status(Boolean status) {
        this.setStatus(status);
        return this;
    }

    public void setStatus(Boolean status) {
        this.status = status;
    }

    public AppUser getAppUser() {
        return this.appUser;
    }

    public void setAppUser(AppUser appUser) {
        this.appUser = appUser;
    }

    public Notification appUser(AppUser appUser) {
        this.setAppUser(appUser);
        return this;
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Notification)) {
            return false;
        }
        return this.id != null && this.id.equals(((Notification)o).id);
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public String toString() {
        return "Notification{id=" + this.getId() + ", name='" + this.getName() + "', description='" + this.getDescription() + "', category='" + this.getCategory() + "', expires='" + this.getExpires() + "', readStatus='" + this.getReadStatus() + "', readAt='" + this.getReadAt() + "', status='" + this.getStatus() + "'}";
    }
}

