/*
 * Decompiled with CFR 0.152.
 */
package com.upl.digitalmodular.domain;

import com.upl.digitalmodular.domain.AbstractAuditingEntity;
import com.upl.digitalmodular.domain.Application;
import java.time.Instant;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Table(name="application_tokens")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class ApplicationToken
extends AbstractAuditingEntity {
    private static final long serialVersionUID = 7225894980176853442L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @ManyToOne
    private Application application;
    @NotNull
    @Column(name="token", nullable=false)
    private String token;
    @Column(name="expire_at")
    private Instant expireAt;
    @Column(name="status")
    private Boolean status;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Instant getExpireAt() {
        return this.expireAt;
    }

    public void setExpireAt(Instant expireAt) {
        this.expireAt = expireAt;
    }

    public Boolean getStatus() {
        return this.status;
    }

    public void setStatus(Boolean status) {
        this.status = status;
    }

    public int hashCode() {
        return Objects.hash(this.application, this.expireAt, this.id, this.status, this.token);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApplicationToken other = (ApplicationToken)obj;
        return Objects.equals(this.application, other.application) && Objects.equals(this.expireAt, other.expireAt) && Objects.equals(this.id, other.id) && Objects.equals(this.status, other.status) && Objects.equals(this.token, other.token);
    }

    public String toString() {
        return "ApplicationToken [id=" + this.id + ", application=" + this.application + ", token=" + this.token + ", expireAt=" + this.expireAt + ", status=" + this.status + "]";
    }
}

