/*
 * Decompiled with CFR 0.152.
 */
package com.upl.digitalmodular.config;

import ch.qos.logback.classic.LoggerContext;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.info.BuildProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Configuration;
import tech.jhipster.config.JHipsterProperties;
import tech.jhipster.config.logging.LoggingUtils;

@Configuration
@RefreshScope
public class LoggingConfiguration {
    public LoggingConfiguration(@Value(value="${spring.application.name}") String appName, @Value(value="${server.port}") String serverPort, JHipsterProperties jHipsterProperties, ObjectProvider<BuildProperties> buildProperties, ObjectMapper mapper) throws JsonProcessingException {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("app_name", appName);
        map.put("app_port", serverPort);
        buildProperties.ifAvailable(it -> map.put("version", it.getVersion()));
        String customFields = mapper.writeValueAsString(map);
        JHipsterProperties.Logging loggingProperties = jHipsterProperties.getLogging();
        JHipsterProperties.Logging.Logstash logstashProperties = loggingProperties.getLogstash();
        if (loggingProperties.isUseJsonFormat()) {
            LoggingUtils.addJsonConsoleAppender((LoggerContext)context, (String)customFields);
        }
        if (logstashProperties.isEnabled()) {
            LoggingUtils.addLogstashTcpSocketAppender((LoggerContext)context, (String)customFields, (JHipsterProperties.Logging.Logstash)logstashProperties);
        }
        if (loggingProperties.isUseJsonFormat() || logstashProperties.isEnabled()) {
            LoggingUtils.addContextListener((LoggerContext)context, (String)customFields, (JHipsterProperties.Logging)loggingProperties);
        }
    }
}

