/*
 * Decompiled with CFR 0.152.
 */
package com.upl.digitalmodular.web.rest;

import com.upl.digitalmodular.service.ApplicationRolesService;
import com.upl.digitalmodular.service.dto.ApplicationRolesDTO;
import com.upl.digitalmodular.service.utility.I18nUtility;
import com.upl.digitalmodular.web.rest.errors.BadRequestAlertException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class ApplicationRolesResource {
    private final Logger log = LoggerFactory.getLogger(ApplicationRolesResource.class);
    private static final String ENTITY_NAME = "digitalmodularApplicationRoles";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final ApplicationRolesService applicationRolesService;
    @Autowired
    private I18nUtility i18nUtility;

    public ApplicationRolesResource(ApplicationRolesService applicationRolesService) {
        this.applicationRolesService = applicationRolesService;
    }

    @PostMapping(value={"/application-roles"})
    @PreAuthorize(value="hasAnyAuthority(\"ADMIN\")")
    public ResponseEntity<ApplicationRolesDTO> createApplicationRoles(@Valid @RequestBody ApplicationRolesDTO applicationRolesDTO) throws URISyntaxException {
        this.log.debug("REST request to save ApplicationRoles : {}", (Object)applicationRolesDTO);
        if (applicationRolesDTO.getId() != null) {
            String message = this.i18nUtility.getMessage("applicationRoles.create.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idexists");
        }
        ApplicationRolesDTO result = this.applicationRolesService.save(applicationRolesDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/application-roles/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/application-roles/{id}"})
    @PreAuthorize(value="hasAnyAuthority(\"ADMIN\")")
    public ResponseEntity<ApplicationRolesDTO> updateApplicationRoles(@PathVariable(value="id", required=false) Long id, @Valid @RequestBody ApplicationRolesDTO applicationRolesDTO) throws URISyntaxException {
        this.log.debug("REST request to update ApplicationRoles : {}, {}", (Object)id, (Object)applicationRolesDTO);
        if (applicationRolesDTO.getId() == null) {
            String message = this.i18nUtility.getMessage("applicationRoles.update.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idnull");
        }
        ApplicationRolesDTO result = this.applicationRolesService.save(applicationRolesDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)applicationRolesDTO.getId().toString()))).body((Object)result);
    }

    @PatchMapping(value={"/application-roles/{id}"}, consumes={"application/json", "application/merge-patch+json"})
    @PreAuthorize(value="hasAnyAuthority(\"ADMIN\")")
    public ResponseEntity<ApplicationRolesDTO> partialUpdateApplicationRoles(@PathVariable(value="id", required=false) Long id, @NotNull @RequestBody ApplicationRolesDTO applicationRolesDTO) throws URISyntaxException {
        this.log.debug("REST request to partial update ApplicationRoles partially : {}, {}", (Object)id, (Object)applicationRolesDTO);
        if (applicationRolesDTO.getId() == null) {
            String message = this.i18nUtility.getMessage("applicationRoles.patch.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idnull");
        }
        Optional result = this.applicationRolesService.partialUpdate(applicationRolesDTO);
        return ResponseUtil.wrapOrNotFound((Optional)result, (HttpHeaders)HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)applicationRolesDTO.getId().toString()));
    }

    @GetMapping(value={"/application-roles"})
    public List<ApplicationRolesDTO> getAllApplicationRoles() {
        this.log.debug("REST request to get all ApplicationRoles");
        return this.applicationRolesService.findAll();
    }

    @GetMapping(value={"/application-roles/{id}"})
    public ResponseEntity<ApplicationRolesDTO> getApplicationRoles(@PathVariable Long id) {
        this.log.debug("REST request to get ApplicationRoles : {}", (Object)id);
        Optional applicationRolesDTO = this.applicationRolesService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)applicationRolesDTO);
    }

    @DeleteMapping(value={"/application-roles/{id}"})
    @PreAuthorize(value="hasAnyAuthority(\"ADMIN\")")
    public ResponseEntity<Void> deleteApplicationRoles(@PathVariable Long id) {
        this.log.debug("REST request to delete ApplicationRoles : {}", (Object)id);
        this.applicationRolesService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

