/*
 * Decompiled with CFR 0.152.
 */
package com.upl.digitalmodular.web.rest;

import com.upl.digitalmodular.service.ApplicationQueryService;
import com.upl.digitalmodular.service.ApplicationService;
import com.upl.digitalmodular.service.criteria.ApplicationCriteria;
import com.upl.digitalmodular.service.dto.ApplicationDTO;
import com.upl.digitalmodular.service.utility.I18nUtility;
import com.upl.digitalmodular.web.rest.errors.BadRequestAlertException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class ApplicationResource {
    private final Logger log = LoggerFactory.getLogger(ApplicationResource.class);
    private static final String ENTITY_NAME = "digitalmodularApplication";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final ApplicationService applicationService;
    private final ApplicationQueryService applicationQueryService;
    @Autowired
    private I18nUtility i18nUtility;

    public ApplicationResource(ApplicationService applicationService, ApplicationQueryService applicationQueryService) {
        this.applicationService = applicationService;
        this.applicationQueryService = applicationQueryService;
    }

    @PostMapping(value={"/applications"})
    @PreAuthorize(value="hasAnyAuthority(\"ADMIN\")")
    public ResponseEntity<ApplicationDTO> createApplication(@Valid @RequestBody ApplicationDTO applicationDTO) throws URISyntaxException {
        this.log.debug("REST request to save Application : {}", (Object)applicationDTO);
        if (applicationDTO.getId() != null) {
            String message = this.i18nUtility.getMessage("application.create.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idexists");
        }
        this.applicationService.checkApplicationExist(applicationDTO);
        ApplicationDTO result = this.applicationService.save(applicationDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/applications/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/applications/{id}"})
    @PreAuthorize(value="hasAnyAuthority(\"ADMIN\")")
    public ResponseEntity<ApplicationDTO> updateApplication(@PathVariable(value="id", required=false) Long id, @Valid @RequestBody ApplicationDTO applicationDTO) throws URISyntaxException {
        this.log.debug("REST request to update Application : {}, {}", (Object)id, (Object)applicationDTO);
        if (applicationDTO.getId() == null) {
            String message = this.i18nUtility.getMessage("application.update.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idnull");
        }
        this.applicationService.updateCheckApplicationExist(applicationDTO, id);
        ApplicationDTO result = this.applicationService.save(applicationDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)applicationDTO.getId().toString()))).body((Object)result);
    }

    @PatchMapping(value={"/applications/{id}"}, consumes={"application/json", "application/merge-patch+json"})
    @PreAuthorize(value="hasAnyAuthority(\"ADMIN\")")
    public ResponseEntity<ApplicationDTO> partialUpdateApplication(@PathVariable(value="id", required=false) Long id, @NotNull @RequestBody ApplicationDTO applicationDTO) throws URISyntaxException {
        this.log.debug("REST request to partial update Application partially : {}, {}", (Object)id, (Object)applicationDTO);
        if (applicationDTO.getId() == null) {
            String message = this.i18nUtility.getMessage("application.patch.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idnull");
        }
        Optional result = this.applicationService.partialUpdate(applicationDTO);
        return ResponseUtil.wrapOrNotFound((Optional)result, (HttpHeaders)HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)applicationDTO.getId().toString()));
    }

    @GetMapping(value={"/applications"})
    public ResponseEntity<Page<ApplicationDTO>> getAllApplications(ApplicationCriteria criteria, Pageable pageable) {
        this.log.debug("REST request to get Applications by criteria: {}", (Object)criteria);
        Page entityList = this.applicationQueryService.findByCriteria(criteria, pageable);
        return ResponseEntity.ok().body((Object)entityList);
    }

    @GetMapping(value={"/applications/count"})
    public ResponseEntity<Long> countApplications(ApplicationCriteria criteria) {
        this.log.debug("REST request to count Applications by criteria: {}", (Object)criteria);
        return ResponseEntity.ok().body((Object)this.applicationQueryService.countByCriteria(criteria));
    }

    @GetMapping(value={"/applications/{id}"})
    public ResponseEntity<ApplicationDTO> getApplication(@PathVariable Long id) {
        this.log.debug("REST request to get Application : {}", (Object)id);
        Optional applicationDTO = this.applicationService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)applicationDTO);
    }

    @DeleteMapping(value={"/applications/{id}"})
    @PreAuthorize(value="hasAnyAuthority(\"ADMIN\")")
    public ResponseEntity<Void> deleteApplication(@PathVariable Long id) {
        this.log.debug("REST request to delete Application : {}", (Object)id);
        this.applicationService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }

    @PostMapping(value={"/upload-application-logo"})
    public ResponseEntity<Map<String, String>> uploadFile(@RequestPart(value="file") MultipartFile file) throws IOException {
        this.log.debug("Request to upload application logo with image : {}", (Object)file.getOriginalFilename());
        String fileURL = this.applicationService.uploadApplicationLogo(file);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("applicationLogo", fileURL);
        return new ResponseEntity(map, HttpStatus.OK);
    }

    @GetMapping(value={"/applications/assigned"})
    public ResponseEntity<Page<ApplicationDTO>> getAssignedApplications(@RequestParam(value="userId", required=true) Long userId, ApplicationCriteria criteria, Pageable pageable) {
        this.log.debug("REST request to get assigned Applications by criteria: {}", (Object)criteria);
        Page entityList = this.applicationService.findAssignedApplications(userId, criteria, pageable);
        return ResponseEntity.ok().body((Object)entityList);
    }

    @GetMapping(value={"/applications/non-assigned"})
    public ResponseEntity<Page<ApplicationDTO>> getNonAssignedApplications(@RequestParam(value="userId", required=true) Long userId, ApplicationCriteria criteria, Pageable pageable) {
        this.log.debug("REST request to get non-assigned Applications by criteria: {}", (Object)criteria);
        Page entityList = this.applicationService.findNonAssignedApplications(userId, criteria, pageable);
        return ResponseEntity.ok().body((Object)entityList);
    }
}

