/*
 * Decompiled with CFR 0.152.
 */
package com.upl.digitalmodular.web.rest;

import com.upl.digitalmodular.service.AppKeyService;
import com.upl.digitalmodular.service.dto.AppKeyDTO;
import com.upl.digitalmodular.service.utility.I18nUtility;
import com.upl.digitalmodular.web.rest.errors.BadRequestAlertException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.PaginationUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class AppKeyResource {
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final Logger log = LoggerFactory.getLogger(AppKeyResource.class);
    private static final String ENTITY_NAME = "digitalmodularAppKey";
    @Autowired
    private I18nUtility i18nUtility;
    private final AppKeyService appKeyService;

    public AppKeyResource(AppKeyService appKeyService) {
        this.appKeyService = appKeyService;
    }

    @PostMapping(value={"/app-key"})
    @PreAuthorize(value="hasAnyAuthority(\"ADMIN\")")
    public ResponseEntity<AppKeyDTO> createAppKey(@Valid @RequestBody AppKeyDTO appKeyDTO) throws URISyntaxException {
        this.log.debug("REST request to save AppKey : {}", (Object)appKeyDTO);
        if (appKeyDTO.getId() != null) {
            String message = this.i18nUtility.getMessage("appKey.create.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idexists");
        }
        AppKeyDTO result = this.appKeyService.save(appKeyDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/app-key/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/app-key/{id}"})
    public ResponseEntity<AppKeyDTO> updateAppKey(@PathVariable(value="id", required=false) Long id, @Valid @RequestBody AppKeyDTO appKeyDTO) throws URISyntaxException {
        this.log.debug("REST request to update AppKey : {}, {}", (Object)id, (Object)appKeyDTO);
        if (appKeyDTO.getId() == null) {
            String message = this.i18nUtility.getMessage("appKey.update.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idnull");
        }
        AppKeyDTO result = this.appKeyService.save(appKeyDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)appKeyDTO.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/app-Key/all"})
    public ResponseEntity<Page<AppKeyDTO>> getAllAppKey(Pageable pageable) {
        this.log.debug("REST request to get AppKey");
        Page page = this.appKeyService.findAll(pageable);
        HttpHeaders headers = PaginationUtil.generatePaginationHttpHeaders((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequest(), (Page)page);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)page);
    }

    @GetMapping(value={"/app-Key/{id}"})
    public ResponseEntity<AppKeyDTO> getAppKey(@PathVariable Long id) {
        this.log.debug("REST request to get AppKey : {}", (Object)id);
        Optional appKeyDTO = this.appKeyService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)appKeyDTO);
    }

    @DeleteMapping(value={"/app-Key/{id}"})
    public ResponseEntity<Void> deleteAppKey(@PathVariable Long id) {
        this.log.debug("REST request to delete AppKey : {}", (Object)id);
        this.appKeyService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)false, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

