/*
 * Decompiled with CFR 0.152.
 */
package com.upl.digitalmodular.service.utility;

import com.upl.digitalmodular.service.exception.BadRequestException;
import com.upl.digitalmodular.service.utility.I18nUtility;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class ImageUtility {
    @Value(value="${application.allowed-image-content-types}")
    private List<String> allowedImageContentTypes;
    @Value(value="${application.allowed-image-extention-types}")
    private List<String> allowedImageExtentionTypes;
    @Autowired
    private I18nUtility i18nUtility;

    public String validateImage(MultipartFile file) {
        String[] parts = StringUtils.split((String)file.getOriginalFilename().toLowerCase(), (String)".");
        if (parts.length != 2 || !this.allowedImageExtentionTypes.contains(parts[parts.length - 1])) {
            String message = this.i18nUtility.getMessage("imageUtility.invalid.file.extension", null);
            throw new BadRequestException(message);
        }
        return "Image Validated Successfully";
    }
}

