/*
 * Decompiled with CFR 0.152.
 */
package com.upl.digitalmodular.service.mapper;

import com.upl.digitalmodular.domain.Application;
import com.upl.digitalmodular.domain.ApplicationRoles;
import com.upl.digitalmodular.service.dto.ApplicationDTO;
import com.upl.digitalmodular.service.dto.ApplicationRolesDTO;
import com.upl.digitalmodular.service.mapper.ApplicationMapper;
import com.upl.digitalmodular.service.mapper.ApplicationRolesMapper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApplicationMapperImpl
implements ApplicationMapper {
    @Autowired
    private ApplicationRolesMapper applicationRolesMapper;

    public List<Application> toEntity(List<ApplicationDTO> dtoList) {
        if (dtoList == null) {
            return null;
        }
        ArrayList<Application> list = new ArrayList<Application>(dtoList.size());
        for (ApplicationDTO applicationDTO : dtoList) {
            list.add(this.toEntity(applicationDTO));
        }
        return list;
    }

    public List<ApplicationDTO> toDto(List<Application> entityList) {
        if (entityList == null) {
            return null;
        }
        ArrayList<ApplicationDTO> list = new ArrayList<ApplicationDTO>(entityList.size());
        for (Application application : entityList) {
            list.add(this.toDto(application));
        }
        return list;
    }

    public void partialUpdate(Application entity, ApplicationDTO dto) {
        if (dto == null) {
            return;
        }
        if (dto.getId() != null) {
            entity.setId(dto.getId());
        }
        if (dto.getName() != null) {
            entity.setName(dto.getName());
        }
        if (dto.getTitle() != null) {
            entity.setTitle(dto.getTitle());
        }
        if (dto.getDescription() != null) {
            entity.setDescription(dto.getDescription());
        }
        if (dto.getApplicationUrl() != null) {
            entity.setApplicationUrl(dto.getApplicationUrl());
        }
        if (dto.getApplicationApiUrl() != null) {
            entity.setApplicationApiUrl(dto.getApplicationApiUrl());
        }
        if (dto.getApplicationLogo() != null) {
            entity.setApplicationLogo(dto.getApplicationLogo());
        }
        if (dto.getStatus() != null) {
            entity.setStatus(dto.getStatus());
        }
        if (entity.getApplicationRoles() != null) {
            Set set = this.applicationRolesDTOSetToApplicationRolesSet(dto.getApplicationRoles());
            if (set != null) {
                entity.getApplicationRoles().clear();
                entity.getApplicationRoles().addAll(set);
            }
        } else {
            Set set = this.applicationRolesDTOSetToApplicationRolesSet(dto.getApplicationRoles());
            if (set != null) {
                entity.applicationRoles(set);
            }
        }
    }

    public ApplicationDTO toDto(Application s) {
        if (s == null) {
            return null;
        }
        ApplicationDTO applicationDTO = new ApplicationDTO();
        applicationDTO.setApplicationRoles(this.applicationRolesMapper.toDtoIdSet(s.getApplicationRoles()));
        applicationDTO.setId(s.getId());
        applicationDTO.setName(s.getName());
        applicationDTO.setTitle(s.getTitle());
        applicationDTO.setDescription(s.getDescription());
        applicationDTO.setApplicationUrl(s.getApplicationUrl());
        applicationDTO.setApplicationLogo(s.getApplicationLogo());
        applicationDTO.setStatus(s.getStatus());
        applicationDTO.setApplicationApiUrl(s.getApplicationApiUrl());
        return applicationDTO;
    }

    public ApplicationDTO toDtoId(Application application) {
        if (application == null) {
            return null;
        }
        ApplicationDTO applicationDTO = new ApplicationDTO();
        applicationDTO.setId(application.getId());
        return applicationDTO;
    }

    public Application toEntity(ApplicationDTO applicationDTO) {
        if (applicationDTO == null) {
            return null;
        }
        Application application = new Application();
        application.setId(applicationDTO.getId());
        application.setName(applicationDTO.getName());
        application.setTitle(applicationDTO.getTitle());
        application.setDescription(applicationDTO.getDescription());
        application.setApplicationUrl(applicationDTO.getApplicationUrl());
        application.setApplicationApiUrl(applicationDTO.getApplicationApiUrl());
        application.setApplicationLogo(applicationDTO.getApplicationLogo());
        application.setStatus(applicationDTO.getStatus());
        application.applicationRoles(this.applicationRolesDTOSetToApplicationRolesSet(applicationDTO.getApplicationRoles()));
        return application;
    }

    protected Set<ApplicationRoles> applicationRolesDTOSetToApplicationRolesSet(Set<ApplicationRolesDTO> set) {
        if (set == null) {
            return null;
        }
        HashSet<ApplicationRoles> set1 = new HashSet<ApplicationRoles>(Math.max((int)((float)set.size() / 0.75f) + 1, 16));
        for (ApplicationRolesDTO applicationRolesDTO : set) {
            set1.add((ApplicationRoles)this.applicationRolesMapper.toEntity((Object)applicationRolesDTO));
        }
        return set1;
    }
}

