/*
 * Decompiled with CFR 0.152.
 */
package com.upl.digitalmodular.service.impl;

import com.upl.digitalmodular.domain.State;
import com.upl.digitalmodular.repository.StateRepository;
import com.upl.digitalmodular.service.StateService;
import com.upl.digitalmodular.service.dto.StateDTO;
import com.upl.digitalmodular.service.exception.BadRequestException;
import com.upl.digitalmodular.service.mapper.StateMapper;
import com.upl.digitalmodular.service.utility.I18nUtility;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class StateServiceImpl
implements StateService {
    private final Logger log = LoggerFactory.getLogger(StateServiceImpl.class);
    private final StateRepository stateRepository;
    private final StateMapper stateMapper;
    @Autowired
    private I18nUtility i18nUtility;

    public StateServiceImpl(StateRepository stateRepository, StateMapper stateMapper) {
        this.stateRepository = stateRepository;
        this.stateMapper = stateMapper;
    }

    public StateDTO save(StateDTO stateDTO) {
        this.log.debug("Request to save State : {}", (Object)stateDTO);
        State state = (State)this.stateMapper.toEntity((Object)stateDTO);
        state = (State)this.stateRepository.save((Object)state);
        return this.stateMapper.toDto(state);
    }

    public Optional<StateDTO> partialUpdate(StateDTO stateDTO) {
        this.log.debug("Request to partially update State : {}", (Object)stateDTO);
        return this.stateRepository.findById((Object)stateDTO.getId()).map(existingState -> {
            this.stateMapper.partialUpdate(existingState, (Object)stateDTO);
            return existingState;
        }).map(arg_0 -> ((StateRepository)this.stateRepository).save(arg_0)).map(arg_0 -> ((StateMapper)this.stateMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public List<StateDTO> findAll() {
        this.log.debug("Request to get all States");
        return this.stateRepository.findAll().stream().map(arg_0 -> ((StateMapper)this.stateMapper).toDto(arg_0)).collect(Collectors.toCollection(LinkedList::new));
    }

    @Transactional(readOnly=true)
    public Optional<StateDTO> findOne(Long id) {
        this.log.debug("Request to get State : {}", (Object)id);
        if (!this.stateRepository.existsById((Object)id)) {
            String message = this.i18nUtility.getMessage("stateRepository.get.entity.exception", null);
            throw new BadRequestException(message);
        }
        return this.stateRepository.findById((Object)id).map(arg_0 -> ((StateMapper)this.stateMapper).toDto(arg_0));
    }

    public void delete(Long id) {
        this.log.debug("Request to delete State : {}", (Object)id);
        Optional state = this.stateRepository.findById((Object)id);
        if (!state.isPresent()) {
            String message = this.i18nUtility.getMessage("stateRepository.delete.id.exception", null);
            throw new BadRequestException(message);
        }
        ((State)state.get()).setStatus(Boolean.valueOf(false));
        this.stateRepository.save((Object)((State)state.get()));
    }
}

