/*
 * Decompiled with CFR 0.152.
 */
package com.upl.digitalmodular.service.impl;

import com.upl.digitalmodular.domain.Country;
import com.upl.digitalmodular.repository.CountryRepository;
import com.upl.digitalmodular.service.CountryService;
import com.upl.digitalmodular.service.dto.CountryDTO;
import com.upl.digitalmodular.service.exception.BadRequestException;
import com.upl.digitalmodular.service.mapper.CountryMapper;
import com.upl.digitalmodular.service.utility.I18nUtility;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CountryServiceImpl
implements CountryService {
    private final Logger log = LoggerFactory.getLogger(CountryServiceImpl.class);
    private final CountryRepository countryRepository;
    private final CountryMapper countryMapper;
    @Autowired
    private I18nUtility i18nUtility;

    public CountryServiceImpl(CountryRepository countryRepository, CountryMapper countryMapper) {
        this.countryRepository = countryRepository;
        this.countryMapper = countryMapper;
    }

    public CountryDTO save(CountryDTO countryDTO) {
        this.log.debug("Request to save Country : {}", (Object)countryDTO);
        Country country = (Country)this.countryMapper.toEntity((Object)countryDTO);
        country = (Country)this.countryRepository.save((Object)country);
        return (CountryDTO)this.countryMapper.toDto((Object)country);
    }

    public Optional<CountryDTO> partialUpdate(CountryDTO countryDTO) {
        this.log.debug("Request to partially update Country : {}", (Object)countryDTO);
        return this.countryRepository.findById((Object)countryDTO.getId()).map(existingCountry -> {
            this.countryMapper.partialUpdate(existingCountry, (Object)countryDTO);
            return existingCountry;
        }).map(arg_0 -> ((CountryRepository)this.countryRepository).save(arg_0)).map(arg_0 -> ((CountryMapper)this.countryMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public List<CountryDTO> findAll() {
        this.log.debug("Request to get all Countries");
        return this.countryRepository.findAll().stream().map(arg_0 -> ((CountryMapper)this.countryMapper).toDto(arg_0)).collect(Collectors.toCollection(LinkedList::new));
    }

    @Transactional(readOnly=true)
    public Optional<CountryDTO> findOne(Long id) {
        this.log.debug("Request to get Country : {}", (Object)id);
        if (!this.countryRepository.existsById((Object)id)) {
            String message = this.i18nUtility.getMessage("countryRepository.get.entity.exception", null);
            throw new BadRequestException(message);
        }
        return this.countryRepository.findById((Object)id).map(arg_0 -> ((CountryMapper)this.countryMapper).toDto(arg_0));
    }

    public void delete(Long id) {
        this.log.debug("Request to delete Country : {}", (Object)id);
        Optional country = this.countryRepository.findById((Object)id);
        if (!country.isPresent()) {
            String message = this.i18nUtility.getMessage("countryRepository.delete.id.exception", null);
            throw new BadRequestException(message);
        }
        ((Country)country.get()).setStatus(Boolean.valueOf(false));
        this.countryRepository.save((Object)((Country)country.get()));
    }
}

