/*
 * Decompiled with CFR 0.152.
 */
package com.upl.digitalmodular.service.impl;

import com.upl.digitalmodular.domain.ApplicationRoles;
import com.upl.digitalmodular.repository.ApplicationRolesRepository;
import com.upl.digitalmodular.service.ApplicationRolesService;
import com.upl.digitalmodular.service.dto.ApplicationRolesDTO;
import com.upl.digitalmodular.service.exception.BadRequestException;
import com.upl.digitalmodular.service.mapper.ApplicationRolesMapper;
import com.upl.digitalmodular.service.utility.I18nUtility;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ApplicationRolesServiceImpl
implements ApplicationRolesService {
    private final Logger log = LoggerFactory.getLogger(ApplicationRolesServiceImpl.class);
    private final ApplicationRolesRepository applicationRolesRepository;
    private final ApplicationRolesMapper applicationRolesMapper;
    @Autowired
    private I18nUtility i18nUtility;

    public ApplicationRolesServiceImpl(ApplicationRolesRepository applicationRolesRepository, ApplicationRolesMapper applicationRolesMapper) {
        this.applicationRolesRepository = applicationRolesRepository;
        this.applicationRolesMapper = applicationRolesMapper;
    }

    public ApplicationRolesDTO save(ApplicationRolesDTO applicationRolesDTO) {
        this.log.debug("Request to save ApplicationRoles : {}", (Object)applicationRolesDTO);
        ApplicationRoles applicationRoles = (ApplicationRoles)this.applicationRolesMapper.toEntity((Object)applicationRolesDTO);
        applicationRoles = (ApplicationRoles)this.applicationRolesRepository.save((Object)applicationRoles);
        return (ApplicationRolesDTO)this.applicationRolesMapper.toDto((Object)applicationRoles);
    }

    public Optional<ApplicationRolesDTO> partialUpdate(ApplicationRolesDTO applicationRolesDTO) {
        this.log.debug("Request to partially update ApplicationRoles : {}", (Object)applicationRolesDTO);
        return this.applicationRolesRepository.findById((Object)applicationRolesDTO.getId()).map(existingApplicationRoles -> {
            this.applicationRolesMapper.partialUpdate(existingApplicationRoles, (Object)applicationRolesDTO);
            return existingApplicationRoles;
        }).map(arg_0 -> ((ApplicationRolesRepository)this.applicationRolesRepository).save(arg_0)).map(arg_0 -> ((ApplicationRolesMapper)this.applicationRolesMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public List<ApplicationRolesDTO> findAll() {
        this.log.debug("Request to get all ApplicationRoles");
        return this.applicationRolesRepository.findAll().stream().map(arg_0 -> ((ApplicationRolesMapper)this.applicationRolesMapper).toDto(arg_0)).collect(Collectors.toCollection(LinkedList::new));
    }

    @Transactional(readOnly=true)
    public Optional<ApplicationRolesDTO> findOne(Long id) {
        this.log.debug("Request to get ApplicationRoles : {}", (Object)id);
        if (!this.applicationRolesRepository.existsById((Object)id)) {
            String message = this.i18nUtility.getMessage("applicationRolesRepository.get.entity.exception", null);
            throw new BadRequestException(message);
        }
        return this.applicationRolesRepository.findById((Object)id).map(arg_0 -> ((ApplicationRolesMapper)this.applicationRolesMapper).toDto(arg_0));
    }

    public void delete(Long id) {
        this.log.debug("Request to delete ApplicationRoles : {}", (Object)id);
        Optional applicationRole = this.applicationRolesRepository.findById((Object)id);
        if (!applicationRole.isPresent()) {
            String message = this.i18nUtility.getMessage("applicationRolesRepository.delete.id.exception", null);
            throw new BadRequestException(message);
        }
        ((ApplicationRoles)applicationRole.get()).setStatus(Boolean.valueOf(false));
        this.applicationRolesRepository.save((Object)((ApplicationRoles)applicationRole.get()));
    }
}

