/*
 * Decompiled with CFR 0.152.
 */
package com.upl.digitalmodular.service.impl;

import com.upl.digitalmodular.domain.AppUser;
import com.upl.digitalmodular.domain.AppUserApplicationAccess;
import com.upl.digitalmodular.domain.Application;
import com.upl.digitalmodular.domain.ApplicationAccessRequest;
import com.upl.digitalmodular.domain.Notification;
import com.upl.digitalmodular.domain.enumeration.AccessStatus;
import com.upl.digitalmodular.domain.enumeration.Category;
import com.upl.digitalmodular.repository.AppUserApplicationAccessRepository;
import com.upl.digitalmodular.repository.AppUserRepository;
import com.upl.digitalmodular.repository.ApplicationAccessRequestRepository;
import com.upl.digitalmodular.repository.ApplicationRepository;
import com.upl.digitalmodular.repository.NotificationRepository;
import com.upl.digitalmodular.service.AppUserApplicationAccessService;
import com.upl.digitalmodular.service.dto.AppUserApplicationAccessDTO;
import com.upl.digitalmodular.service.exception.BadRequestException;
import com.upl.digitalmodular.service.mapper.AppUserApplicationAccessMapper;
import com.upl.digitalmodular.service.utility.I18nUtility;
import java.time.Instant;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AppUserApplicationAccessServiceImpl
implements AppUserApplicationAccessService {
    private final Logger log = LoggerFactory.getLogger(AppUserApplicationAccessServiceImpl.class);
    private final AppUserApplicationAccessRepository appUserApplicationAccessRepository;
    private final AppUserApplicationAccessMapper appUserApplicationAccessMapper;
    private final AppUserRepository appUserRepository;
    private final NotificationRepository notificationRepository;
    private final ApplicationRepository applicationRepository;
    private final ApplicationAccessRequestRepository applicationAccessRequestRepository;
    @Autowired
    private I18nUtility i18nUtility;

    public AppUserApplicationAccessServiceImpl(AppUserApplicationAccessRepository appUserApplicationAccessRepository, AppUserApplicationAccessMapper appUserApplicationAccessMapper, NotificationRepository notificationRepository, AppUserRepository appUserRepository, ApplicationRepository applicationRepository, ApplicationAccessRequestRepository applicationAccessRequestRepository) {
        this.appUserApplicationAccessRepository = appUserApplicationAccessRepository;
        this.appUserApplicationAccessMapper = appUserApplicationAccessMapper;
        this.appUserRepository = appUserRepository;
        this.notificationRepository = notificationRepository;
        this.applicationRepository = applicationRepository;
        this.applicationAccessRequestRepository = applicationAccessRequestRepository;
    }

    public AppUserApplicationAccessDTO save(AppUserApplicationAccessDTO appUserApplicationAccessDTO) {
        this.log.debug("Request to save AppUserApplicationAccess : {}", (Object)appUserApplicationAccessDTO);
        AppUserApplicationAccess appUserApplicationAccess = (AppUserApplicationAccess)this.appUserApplicationAccessMapper.toEntity((Object)appUserApplicationAccessDTO);
        AppUser appUser = (AppUser)this.appUserRepository.findById((Object)appUserApplicationAccessDTO.getAppUser().getId()).get();
        Application application = (Application)this.applicationRepository.findById((Object)appUserApplicationAccessDTO.getApplication().getId()).get();
        Optional accessCheck = this.appUserApplicationAccessRepository.findByAppUserIdAndApplicationId(appUser.getId(), application.getId());
        if (appUserApplicationAccessDTO.getId() == null) {
            Optional applicationRequest = this.applicationAccessRequestRepository.findByAppUserIdAndApplicationId(appUser.getId(), application.getId());
            if (applicationRequest.isEmpty()) {
                String message = this.i18nUtility.getMessage("applicationAccessRequestRepository.get.entity.exception", null);
                throw new BadRequestException(message);
            }
            if (accessCheck.isPresent()) {
                if (((AppUserApplicationAccess)accessCheck.get()).getAccessStatus().equals(true)) {
                    String message = this.i18nUtility.getMessage("applicationAccessRequestRepository.access.existed.exception", null);
                    throw new BadRequestException(message);
                }
                if (((AppUserApplicationAccess)accessCheck.get()).getAccessStatus().equals(false)) {
                    ((AppUserApplicationAccess)accessCheck.get()).setAccessStatus(Boolean.valueOf(true));
                    ((AppUserApplicationAccess)accessCheck.get()).setAccessAt(Instant.now());
                    ((ApplicationAccessRequest)applicationRequest.get()).setStatus(AccessStatus.ACCEPTED);
                    this.applicationAccessRequestRepository.save((Object)((ApplicationAccessRequest)applicationRequest.get()));
                    this.sendAccessNotification(appUser, application, Boolean.valueOf(true));
                    appUserApplicationAccess = (AppUserApplicationAccess)this.appUserApplicationAccessRepository.save((Object)((AppUserApplicationAccess)accessCheck.get()));
                    return this.appUserApplicationAccessMapper.toDto((AppUserApplicationAccess)accessCheck.get());
                }
            }
            appUserApplicationAccess.setAccessStatus(Boolean.valueOf(true));
            appUserApplicationAccess.setStatus(Boolean.valueOf(true));
            appUserApplicationAccess.setAccessAt(Instant.now());
            ((ApplicationAccessRequest)applicationRequest.get()).setStatus(AccessStatus.ACCEPTED);
            this.applicationAccessRequestRepository.save((Object)((ApplicationAccessRequest)applicationRequest.get()));
            this.sendAccessNotification(appUser, application, Boolean.valueOf(true));
        }
        appUserApplicationAccess = (AppUserApplicationAccess)this.appUserApplicationAccessRepository.save((Object)appUserApplicationAccess);
        return this.appUserApplicationAccessMapper.toDto(appUserApplicationAccess);
    }

    public Optional<AppUserApplicationAccessDTO> partialUpdate(AppUserApplicationAccessDTO appUserApplicationAccessDTO) {
        this.log.debug("Request to partially update AppUserApplicationAccess : {}", (Object)appUserApplicationAccessDTO);
        return this.appUserApplicationAccessRepository.findById((Object)appUserApplicationAccessDTO.getId()).map(existingAppUserApplicationAccess -> {
            this.appUserApplicationAccessMapper.partialUpdate(existingAppUserApplicationAccess, (Object)appUserApplicationAccessDTO);
            return existingAppUserApplicationAccess;
        }).map(arg_0 -> ((AppUserApplicationAccessRepository)this.appUserApplicationAccessRepository).save(arg_0)).map(arg_0 -> ((AppUserApplicationAccessMapper)this.appUserApplicationAccessMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public List<AppUserApplicationAccessDTO> findAll() {
        this.log.debug("Request to get all AppUserApplicationAccesses");
        return this.appUserApplicationAccessRepository.findAll().stream().map(arg_0 -> ((AppUserApplicationAccessMapper)this.appUserApplicationAccessMapper).toDto(arg_0)).collect(Collectors.toCollection(LinkedList::new));
    }

    @Transactional(readOnly=true)
    public Optional<AppUserApplicationAccessDTO> findOne(Long id) {
        this.log.debug("Request to get AppUserApplicationAccess : {}", (Object)id);
        if (!this.appUserApplicationAccessRepository.existsById((Object)id)) {
            String message = this.i18nUtility.getMessage("appUserApplicationAccessRepository.get.entity.exception", null);
            throw new BadRequestException(message);
        }
        return this.appUserApplicationAccessRepository.findById((Object)id).map(arg_0 -> ((AppUserApplicationAccessMapper)this.appUserApplicationAccessMapper).toDto(arg_0));
    }

    public void delete(Long id) {
        this.log.debug("Request to delete AppUserApplicationAccess : {}", (Object)id);
        Optional applicationAccess = this.appUserApplicationAccessRepository.findById((Object)id);
        if (!applicationAccess.isPresent()) {
            String message = this.i18nUtility.getMessage("appUserApplicationAccessRepository.delete.id.exception", null);
            throw new BadRequestException(message);
        }
        ((AppUserApplicationAccess)applicationAccess.get()).setStatus(Boolean.valueOf(false));
        this.appUserApplicationAccessRepository.save((Object)((AppUserApplicationAccess)applicationAccess.get()));
    }

    @Transactional(readOnly=true)
    public List<AppUserApplicationAccess> findUserApplications(Long id) {
        return this.appUserApplicationAccessRepository.findByAppUserIdAndAccessStatusTrue(id);
    }

    public void deleteApplicationUser(Long id) {
        this.log.debug("Request to delete AppUserApplicationAccess : {}", (Object)id);
        Optional applicationAccess = this.appUserApplicationAccessRepository.findById((Object)id);
        if (!applicationAccess.isPresent()) {
            String message = this.i18nUtility.getMessage("appUserApplicationAccessRepository.delete.id.exception", null);
            throw new BadRequestException(message);
        }
        Optional applicationRequest = this.applicationAccessRequestRepository.findByAppUserIdAndApplicationId(((AppUserApplicationAccess)applicationAccess.get()).getAppUser().getId(), ((AppUserApplicationAccess)applicationAccess.get()).getApplication().getId());
        if (applicationRequest.isPresent()) {
            ((ApplicationAccessRequest)applicationRequest.get()).setStatus(AccessStatus.DELETED);
            this.applicationAccessRequestRepository.save((Object)((ApplicationAccessRequest)applicationRequest.get()));
        }
        AppUser appUser = (AppUser)this.appUserRepository.findById((Object)((AppUserApplicationAccess)applicationAccess.get()).getAppUser().getId()).get();
        Application application = (Application)this.applicationRepository.findById((Object)((AppUserApplicationAccess)applicationAccess.get()).getApplication().getId()).get();
        this.sendAccessNotification(appUser, application, Boolean.valueOf(false));
        ((AppUserApplicationAccess)applicationAccess.get()).setAccessStatus(Boolean.valueOf(false));
        this.appUserApplicationAccessRepository.save((Object)((AppUserApplicationAccess)applicationAccess.get()));
    }

    public void disableApplications(Long id, List<Long> ids) {
        this.log.debug("Request to disable AppUserApplicationAccess : {}", (Object)id);
        List applications = this.appUserApplicationAccessRepository.findByAppUserIdAndApplicationIdInAndAccessStatusTrue(id, ids);
        if (applications.isEmpty()) {
            String message = this.i18nUtility.getMessage("appUserApplicationAccessRepository.delete.id.exception", null);
            throw new BadRequestException(message);
        }
        List acceptedApplicationRequest = this.applicationAccessRequestRepository.findByAppUserIdAndApplicationIdInAndStatusEquals(id, ids, AccessStatus.ACCEPTED);
        if (acceptedApplicationRequest.size() > 0) {
            acceptedApplicationRequest.stream().map(arg_0 -> ((ApplicationAccessRequestRepository)this.applicationAccessRequestRepository).save(arg_0)).forEach(a -> a.setStatus(AccessStatus.DELETED));
            for (ApplicationAccessRequest a2 : acceptedApplicationRequest) {
                this.sendAccessNotification(a2.getAppUser(), a2.getApplication(), Boolean.valueOf(false));
            }
        }
        applications.stream().map(arg_0 -> ((AppUserApplicationAccessRepository)this.appUserApplicationAccessRepository).save(arg_0)).forEach(c -> c.accessStatus(Boolean.valueOf(false)));
    }

    private void sendAccessNotification(AppUser appUser, Application application, Boolean status) {
        Notification userNotification = new Notification();
        userNotification.setAppUser(appUser);
        userNotification.setApplication(application);
        userNotification.setCategory(Category.NOTICE);
        userNotification.setReadStatus(Boolean.valueOf(false));
        userNotification.setStatus(Boolean.valueOf(true));
        userNotification.setExpires(null);
        if (status.equals(true)) {
            userNotification.setDescription("Your application request for " + application.getName() + " is accepted");
            Optional requestNotification = this.notificationRepository.findByAppUserIdAndApplicationIdAndStatusTrueAndCategoryIs(appUser.getId(), application.getId(), Category.REQUESTACCESS);
            if (requestNotification.isPresent()) {
                ((Notification)requestNotification.get()).setStatus(Boolean.valueOf(false));
                this.notificationRepository.save((Object)((Notification)requestNotification.get()));
            }
        }
        if (status.equals(false)) {
            userNotification.setDescription("Your application access for " + application.getName() + " has been revoked");
        }
        this.notificationRepository.save((Object)userNotification);
    }
}

