/*
 * Decompiled with CFR 0.152.
 */
package com.upl.digitalmodular.service.impl;

import com.upl.digitalmodular.domain.AppKey;
import com.upl.digitalmodular.repository.AppKeyRepository;
import com.upl.digitalmodular.service.AppKeyService;
import com.upl.digitalmodular.service.dto.AppKeyDTO;
import com.upl.digitalmodular.service.exception.BadRequestException;
import com.upl.digitalmodular.service.mapper.AppKeyMapper;
import com.upl.digitalmodular.service.utility.I18nUtility;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AppKeyServiceImpl
implements AppKeyService {
    private final Logger log = LoggerFactory.getLogger(AppKeyServiceImpl.class);
    private final AppKeyRepository appKeyRepository;
    private AppKeyMapper appKeyMapper;
    @Autowired
    private I18nUtility i18nUtility;

    public AppKeyServiceImpl(AppKeyRepository appKeyRepository, AppKeyMapper appKeyMapper) {
        this.appKeyRepository = appKeyRepository;
        this.appKeyMapper = appKeyMapper;
    }

    public AppKeyDTO save(@Valid AppKeyDTO appKeyDTO) {
        this.log.debug("Request to save AppKey : {}", (Object)appKeyDTO);
        AppKey appKey = this.appKeyMapper.toEntity(appKeyDTO);
        if (appKeyDTO.getAdminEmail() != null && appKeyDTO.getAccessKey() != null && appKeyDTO.getSecretKey() != null) {
            appKey = (AppKey)this.appKeyRepository.save((Object)appKey);
        }
        return this.appKeyMapper.toDto(appKey);
    }

    public Optional<AppKeyDTO> findOne(Long id) {
        this.log.debug("Request to get AppKey : {}", (Object)id);
        if (!this.appKeyRepository.existsById((Object)id)) {
            String message = this.i18nUtility.getMessage("appKeyRepository.get.entity.exception", null);
            throw new BadRequestException(message);
        }
        return this.appKeyRepository.findById((Object)id).map(arg_0 -> ((AppKeyMapper)this.appKeyMapper).toDto(arg_0));
    }

    public void delete(Long id) {
        this.log.debug("Request to delete AppKey : {}", (Object)id);
        Optional appKey = this.appKeyRepository.findById((Object)id);
        if (!appKey.isPresent()) {
            String message = this.i18nUtility.getMessage("appKeyRepository.delete.id.exception", null);
            throw new BadRequestException(message);
        }
        ((AppKey)appKey.get()).setStatus(Boolean.valueOf(false));
        this.appKeyRepository.save((Object)((AppKey)appKey.get()));
    }

    public Page<AppKeyDTO> findAll(Pageable pageable) {
        this.log.debug("Request to get all AppKey");
        return this.appKeyRepository.findAll(pageable).map(arg_0 -> ((AppKeyMapper)this.appKeyMapper).toDto(arg_0));
    }
}

