/*
 * Decompiled with CFR 0.152.
 */
package com.upl.digitalmodular.service;

import com.upl.digitalmodular.domain.AppUser_;
import com.upl.digitalmodular.domain.Notification;
import com.upl.digitalmodular.domain.Notification_;
import com.upl.digitalmodular.repository.NotificationRepository;
import com.upl.digitalmodular.service.criteria.NotificationCriteria;
import com.upl.digitalmodular.service.dto.NotificationDTO;
import com.upl.digitalmodular.service.mapper.NotificationMapper;
import java.util.List;
import javax.persistence.criteria.JoinType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tech.jhipster.service.QueryService;
import tech.jhipster.service.filter.Filter;
import tech.jhipster.service.filter.RangeFilter;

@Service
@Transactional(readOnly=true)
public class NotificationQueryService
extends QueryService<Notification> {
    private final Logger log = LoggerFactory.getLogger(NotificationQueryService.class);
    private final NotificationRepository notificationRepository;
    private final NotificationMapper notificationMapper;

    public NotificationQueryService(NotificationRepository notificationRepository, NotificationMapper notificationMapper) {
        this.notificationRepository = notificationRepository;
        this.notificationMapper = notificationMapper;
    }

    @Transactional(readOnly=true)
    public List<NotificationDTO> findByCriteria(NotificationCriteria criteria) {
        this.log.debug("find by criteria : {}", (Object)criteria);
        Specification specification = this.createSpecification(criteria);
        return this.notificationMapper.toDto(this.notificationRepository.findAll(specification));
    }

    @Transactional(readOnly=true)
    public Page<NotificationDTO> findByCriteria(NotificationCriteria criteria, Pageable page) {
        this.log.debug("find by criteria : {}, page: {}", (Object)criteria, (Object)page);
        Specification specification = this.createSpecification(criteria);
        return this.notificationRepository.findAll(specification, page).map(arg_0 -> ((NotificationMapper)this.notificationMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public long countByCriteria(NotificationCriteria criteria) {
        this.log.debug("count by criteria : {}", (Object)criteria);
        Specification specification = this.createSpecification(criteria);
        return this.notificationRepository.count(specification);
    }

    protected Specification<Notification> createSpecification(NotificationCriteria criteria) {
        Specification specification = Specification.where(null);
        if (criteria != null) {
            if (criteria.getDistinct() != null) {
                specification = specification.and(this.distinct(criteria.getDistinct().booleanValue()));
            }
            if (criteria.getId() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getId(), Notification_.id));
            }
            if (criteria.getName() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getName(), Notification_.name));
            }
            if (criteria.getCategory() != null) {
                specification = specification.and(this.buildSpecification((Filter)criteria.getCategory(), Notification_.category));
            }
            if (criteria.getExpires() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getExpires(), Notification_.expires));
            }
            if (criteria.getReadStatus() != null) {
                specification = specification.and(this.buildSpecification((Filter)criteria.getReadStatus(), Notification_.readStatus));
            }
            if (criteria.getReadAt() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getReadAt(), Notification_.readAt));
            }
            if (criteria.getStatus() != null) {
                specification = specification.and(this.buildSpecification((Filter)criteria.getStatus(), Notification_.status));
            }
            if (criteria.getAppUserId() != null) {
                specification = specification.and(this.buildSpecification((RangeFilter)criteria.getAppUserId(), root -> root.join(Notification_.appUser, JoinType.LEFT).get(AppUser_.id)));
            }
        }
        return specification;
    }
}

