/*
 * Decompiled with CFR 0.152.
 */
package com.upl.digitalmodular.service;

import com.upl.digitalmodular.domain.Application;
import com.upl.digitalmodular.domain.ApplicationRoles_;
import com.upl.digitalmodular.domain.Application_;
import com.upl.digitalmodular.repository.ApplicationRepository;
import com.upl.digitalmodular.service.criteria.ApplicationCriteria;
import com.upl.digitalmodular.service.dto.ApplicationDTO;
import com.upl.digitalmodular.service.mapper.ApplicationMapper;
import java.util.List;
import javax.persistence.criteria.JoinType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tech.jhipster.service.QueryService;
import tech.jhipster.service.filter.BooleanFilter;
import tech.jhipster.service.filter.Filter;
import tech.jhipster.service.filter.RangeFilter;

@Service
@Transactional(readOnly=true)
public class ApplicationQueryService
extends QueryService<Application> {
    private final Logger log = LoggerFactory.getLogger(ApplicationQueryService.class);
    private final ApplicationRepository applicationRepository;
    private final ApplicationMapper applicationMapper;

    public ApplicationQueryService(ApplicationRepository applicationRepository, ApplicationMapper applicationMapper) {
        this.applicationRepository = applicationRepository;
        this.applicationMapper = applicationMapper;
    }

    @Transactional(readOnly=true)
    public List<ApplicationDTO> findByCriteria(ApplicationCriteria criteria) {
        this.log.debug("find by criteria : {}", (Object)criteria);
        Specification specification = this.createSpecification(criteria);
        return this.applicationMapper.toDto(this.applicationRepository.findAll(specification));
    }

    @Transactional(readOnly=true)
    public Page<ApplicationDTO> findByCriteria(ApplicationCriteria criteria, Pageable page) {
        this.log.debug("find by criteria : {}, page: {}", (Object)criteria, (Object)page);
        BooleanFilter statusFilter = new BooleanFilter();
        statusFilter.setEquals((Object)true);
        criteria.setStatus(statusFilter);
        Specification specification = this.createSpecification(criteria);
        return this.applicationRepository.findAll(specification, page).map(arg_0 -> ((ApplicationMapper)this.applicationMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public long countByCriteria(ApplicationCriteria criteria) {
        this.log.debug("count by criteria : {}", (Object)criteria);
        Specification specification = this.createSpecification(criteria);
        return this.applicationRepository.count(specification);
    }

    protected Specification<Application> createSpecification(ApplicationCriteria criteria) {
        Specification specification = Specification.where(null);
        if (criteria != null) {
            if (criteria.getDistinct() != null) {
                specification = specification.and(this.distinct(criteria.getDistinct().booleanValue()));
            }
            if (criteria.getId() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getId(), Application_.id));
            }
            if (criteria.getName() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getName(), Application_.name));
            }
            if (criteria.getDescription() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getDescription(), Application_.description));
            }
            if (criteria.getApplicationUrl() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getApplicationUrl(), Application_.applicationUrl));
            }
            if (criteria.getApplicationLogo() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getApplicationLogo(), Application_.applicationLogo));
            }
            if (criteria.getStatus() != null) {
                specification = specification.and(this.buildSpecification((Filter)criteria.getStatus(), Application_.status));
            }
            if (criteria.getApplicationRolesId() != null) {
                specification = specification.and(this.buildSpecification((RangeFilter)criteria.getApplicationRolesId(), root -> root.join(Application_.applicationRoles, JoinType.LEFT).get(ApplicationRoles_.id)));
            }
        }
        return specification;
    }
}

