/*
 * Decompiled with CFR 0.152.
 */
package com.upl.digitalmodular.service;

import com.upl.digitalmodular.domain.AppUser_;
import com.upl.digitalmodular.domain.ApplicationAccessRequest;
import com.upl.digitalmodular.domain.ApplicationAccessRequest_;
import com.upl.digitalmodular.domain.Application_;
import com.upl.digitalmodular.repository.ApplicationAccessRequestRepository;
import com.upl.digitalmodular.service.criteria.ApplicationAccessRequestCriteria;
import com.upl.digitalmodular.service.dto.ApplicationAccessRequestDTO;
import com.upl.digitalmodular.service.mapper.ApplicationAccessRequestMapper;
import java.util.List;
import javax.persistence.criteria.JoinType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tech.jhipster.service.QueryService;
import tech.jhipster.service.filter.Filter;
import tech.jhipster.service.filter.RangeFilter;

@Service
@Transactional(readOnly=true)
public class ApplicationAccessRequestQueryService
extends QueryService<ApplicationAccessRequest> {
    private final Logger log = LoggerFactory.getLogger(ApplicationAccessRequestQueryService.class);
    private final ApplicationAccessRequestRepository applicationAccessRequestRepository;
    private final ApplicationAccessRequestMapper applicationAccessRequestMapper;

    public ApplicationAccessRequestQueryService(ApplicationAccessRequestRepository applicationAccessRequestRepository, ApplicationAccessRequestMapper applicationAccessRequestMapper) {
        this.applicationAccessRequestRepository = applicationAccessRequestRepository;
        this.applicationAccessRequestMapper = applicationAccessRequestMapper;
    }

    @Transactional(readOnly=true)
    public List<ApplicationAccessRequestDTO> findByCriteria(ApplicationAccessRequestCriteria criteria) {
        this.log.debug("find by criteria : {}", (Object)criteria);
        Specification specification = this.createSpecification(criteria);
        return this.applicationAccessRequestMapper.toDto(this.applicationAccessRequestRepository.findAll(specification));
    }

    @Transactional(readOnly=true)
    public Page<ApplicationAccessRequestDTO> findByCriteria(ApplicationAccessRequestCriteria criteria, Pageable page) {
        this.log.debug("find by criteria : {}, page: {}", (Object)criteria, (Object)page);
        Specification specification = this.createSpecification(criteria);
        return this.applicationAccessRequestRepository.findAll(specification, page).map(arg_0 -> ((ApplicationAccessRequestMapper)this.applicationAccessRequestMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public long countByCriteria(ApplicationAccessRequestCriteria criteria) {
        this.log.debug("count by criteria : {}", (Object)criteria);
        Specification specification = this.createSpecification(criteria);
        return this.applicationAccessRequestRepository.count(specification);
    }

    protected Specification<ApplicationAccessRequest> createSpecification(ApplicationAccessRequestCriteria criteria) {
        Specification specification = Specification.where(null);
        if (criteria != null) {
            if (criteria.getDistinct() != null) {
                specification = specification.and(this.distinct(criteria.getDistinct().booleanValue()));
            }
            if (criteria.getId() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getId(), ApplicationAccessRequest_.id));
            }
            if (criteria.getRequestDate() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getRequestDate(), ApplicationAccessRequest_.requestDate));
            }
            if (criteria.getStatus() != null) {
                specification = specification.and(this.buildSpecification((Filter)criteria.getStatus(), ApplicationAccessRequest_.status));
            }
            if (criteria.getApplicationId() != null) {
                specification = specification.and(this.buildSpecification((RangeFilter)criteria.getApplicationId(), root -> root.join(ApplicationAccessRequest_.application, JoinType.LEFT).get(Application_.id)));
            }
            if (criteria.getAppUserId() != null) {
                specification = specification.and(this.buildSpecification((RangeFilter)criteria.getAppUserId(), root -> root.join(ApplicationAccessRequest_.appUser, JoinType.LEFT).get(AppUser_.id)));
            }
        }
        return specification;
    }
}

