/*
 * Decompiled with CFR 0.152.
 */
package com.upl.digitalmodular.service;

import com.upl.digitalmodular.domain.AppUserApplicationAccess;
import com.upl.digitalmodular.domain.AppUserApplicationAccess_;
import com.upl.digitalmodular.domain.AppUser_;
import com.upl.digitalmodular.domain.ApplicationRoles_;
import com.upl.digitalmodular.domain.Application_;
import com.upl.digitalmodular.repository.AppUserApplicationAccessRepository;
import com.upl.digitalmodular.service.criteria.AppUserApplicationAccessCriteria;
import com.upl.digitalmodular.service.dto.AppUserApplicationAccessDTO;
import com.upl.digitalmodular.service.mapper.AppUserApplicationAccessMapper;
import java.util.List;
import javax.persistence.criteria.JoinType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tech.jhipster.service.QueryService;
import tech.jhipster.service.filter.Filter;
import tech.jhipster.service.filter.RangeFilter;

@Service
@Transactional(readOnly=true)
public class AppUserApplicationAccessQueryService
extends QueryService<AppUserApplicationAccess> {
    private final Logger log = LoggerFactory.getLogger(AppUserApplicationAccessQueryService.class);
    private final AppUserApplicationAccessRepository appUserApplicationAccessRepository;
    private final AppUserApplicationAccessMapper appUserApplicationAccessMapper;

    public AppUserApplicationAccessQueryService(AppUserApplicationAccessRepository appUserApplicationAccessRepository, AppUserApplicationAccessMapper appUserApplicationAccessMapper) {
        this.appUserApplicationAccessRepository = appUserApplicationAccessRepository;
        this.appUserApplicationAccessMapper = appUserApplicationAccessMapper;
    }

    @Transactional(readOnly=true)
    public List<AppUserApplicationAccessDTO> findByCriteria(AppUserApplicationAccessCriteria criteria) {
        this.log.debug("find by criteria : {}", (Object)criteria);
        Specification specification = this.createSpecification(criteria);
        return this.appUserApplicationAccessMapper.toDto(this.appUserApplicationAccessRepository.findAll(specification));
    }

    @Transactional(readOnly=true)
    public Page<AppUserApplicationAccessDTO> findByCriteria(AppUserApplicationAccessCriteria criteria, Pageable page) {
        this.log.debug("find by criteria : {}, page: {}", (Object)criteria, (Object)page);
        Specification specification = this.createSpecification(criteria);
        return this.appUserApplicationAccessRepository.findAll(specification, page).map(arg_0 -> ((AppUserApplicationAccessMapper)this.appUserApplicationAccessMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public long countByCriteria(AppUserApplicationAccessCriteria criteria) {
        this.log.debug("count by criteria : {}", (Object)criteria);
        Specification specification = this.createSpecification(criteria);
        return this.appUserApplicationAccessRepository.count(specification);
    }

    protected Specification<AppUserApplicationAccess> createSpecification(AppUserApplicationAccessCriteria criteria) {
        Specification specification = Specification.where(null);
        if (criteria != null) {
            if (criteria.getDistinct() != null) {
                specification = specification.and(this.distinct(criteria.getDistinct().booleanValue()));
            }
            if (criteria.getId() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getId(), AppUserApplicationAccess_.id));
            }
            if (criteria.getAccessStatus() != null) {
                specification = specification.and(this.buildSpecification((Filter)criteria.getAccessStatus(), AppUserApplicationAccess_.accessStatus));
            }
            if (criteria.getStatus() != null) {
                specification = specification.and(this.buildSpecification((Filter)criteria.getStatus(), AppUserApplicationAccess_.status));
            }
            if (criteria.getAccessAt() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getAccessAt(), AppUserApplicationAccess_.accessAt));
            }
            if (criteria.getAppUserId() != null) {
                specification = specification.and(this.buildSpecification((RangeFilter)criteria.getAppUserId(), root -> root.join(AppUserApplicationAccess_.appUser, JoinType.LEFT).get(AppUser_.id)));
            }
            if (criteria.getRoleId() != null) {
                specification = specification.and(this.buildSpecification((RangeFilter)criteria.getRoleId(), root -> root.join(AppUserApplicationAccess_.role, JoinType.LEFT).get(ApplicationRoles_.id)));
            }
            if (criteria.getApplicationId() != null) {
                specification = specification.and(this.buildSpecification((RangeFilter)criteria.getApplicationId(), root -> root.join(AppUserApplicationAccess_.application, JoinType.LEFT).get(Application_.id)));
            }
        }
        return specification;
    }
}

