/*
 * Decompiled with CFR 0.152.
 */
package com.upl.digitalmodular.domain;

import java.io.Serializable;
import java.time.Instant;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Table(name="jhi_entity_audit_event")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class EntityAuditEvent
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @NotNull
    @Column(name="entity_id", nullable=false)
    private Long entityId;
    @NotNull
    @Size(max=255)
    @Column(name="entity_type", length=255, nullable=false)
    private @NotNull @Size(max=255) String entityType;
    @NotNull
    @Size(max=20)
    @Column(name="action", length=20, nullable=false)
    private @NotNull @Size(max=20) String action;
    @Lob
    @Column(name="entity_value")
    private String entityValue;
    @Column(name="commit_version")
    private Integer commitVersion;
    @Size(max=100)
    @Column(name="modified_by", length=100)
    private @Size(max=100) String modifiedBy;
    @NotNull
    @Column(name="modified_date", nullable=false)
    private Instant modifiedDate;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getEntityId() {
        return this.entityId;
    }

    public void setEntityId(Long entityId) {
        this.entityId = entityId;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getEntityValue() {
        return this.entityValue;
    }

    public void setEntityValue(String entityValue) {
        this.entityValue = entityValue;
    }

    public Integer getCommitVersion() {
        return this.commitVersion;
    }

    public void setCommitVersion(Integer commitVersion) {
        this.commitVersion = commitVersion;
    }

    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public Instant getModifiedDate() {
        return this.modifiedDate;
    }

    public void setModifiedDate(Instant modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityAuditEvent entityAuditEvent = (EntityAuditEvent)o;
        return Objects.equals(this.id, entityAuditEvent.id);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public String toString() {
        return "EntityAuditEvent{id=" + this.id + ", entityId='" + this.entityId + "', entityType='" + this.entityType + "', action='" + this.action + "', entityValue='" + this.entityValue + "', commitVersion='" + this.commitVersion + "', modifiedBy='" + this.modifiedBy + "', modifiedDate='" + this.modifiedDate + "'" + '}';
    }
}

