/*
 * Decompiled with CFR 0.152.
 */
package com.upl.depotdashboard.web.rest;

import com.upl.depotdashboard.service.PlantProfitCenterQueryService;
import com.upl.depotdashboard.service.PlantProfitCenterService;
import com.upl.depotdashboard.service.criteria.PlantProfitCenterCriteria;
import com.upl.depotdashboard.service.dto.GraphResponseDTO;
import com.upl.depotdashboard.service.dto.GridResponseDTO;
import com.upl.depotdashboard.service.dto.PlantProfitCenterDTO;
import com.upl.depotdashboard.service.dto.ProfitCenterResponseDTO;
import com.upl.depotdashboard.service.dto.ScanResponseDTO;
import com.upl.depotdashboard.service.dto.SummaryGraphDTO;
import com.upl.depotdashboard.service.utility.I18nUtility;
import com.upl.depotdashboard.web.rest.errors.BadRequestAlertException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.PaginationUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class PlantProfitCenterResource {
    private final Logger log = LoggerFactory.getLogger(PlantProfitCenterResource.class);
    private static final String ENTITY_NAME = "depotdashboardPlantProfitCenter";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    @Autowired
    private I18nUtility i18nUtility;
    private final PlantProfitCenterService plantProfitCenterService;
    private final PlantProfitCenterQueryService plantProfitCenterQueryService;

    public PlantProfitCenterResource(PlantProfitCenterService plantProfitCenterService, PlantProfitCenterQueryService plantProfitCenterQueryService) {
        this.plantProfitCenterService = plantProfitCenterService;
        this.plantProfitCenterQueryService = plantProfitCenterQueryService;
    }

    @PostMapping(value={"/plant-profit-centers"})
    public ResponseEntity<PlantProfitCenterDTO> createPlantProfitCenter(@RequestBody PlantProfitCenterDTO plantProfitCenterDTO) throws URISyntaxException {
        this.log.debug("REST request to save PlantProfitCenter : {}", (Object)plantProfitCenterDTO);
        if (plantProfitCenterDTO.getId() != null) {
            String message = this.i18nUtility.getMessage("plantProfitCenter.save.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idexists");
        }
        PlantProfitCenterDTO result = this.plantProfitCenterService.save(plantProfitCenterDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/plant-profit-centers/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/plant-profit-centers/{id}"})
    public ResponseEntity<PlantProfitCenterDTO> updatePlantProfitCenter(@RequestBody PlantProfitCenterDTO plantProfitCenterDTO) throws URISyntaxException {
        this.log.debug("REST request to update PlantProfitCenter : {}", (Object)plantProfitCenterDTO);
        if (plantProfitCenterDTO.getId() == null) {
            String message = this.i18nUtility.getMessage("plantProfitCenter.update.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idnull");
        }
        PlantProfitCenterDTO result = this.plantProfitCenterService.save(plantProfitCenterDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)plantProfitCenterDTO.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/plant-profit-centers"})
    public ResponseEntity<List<PlantProfitCenterDTO>> getAllPlantProfitCenters(PlantProfitCenterCriteria criteria, Pageable pageable) {
        this.log.debug("REST request to get PlantProfitCenters by criteria: {}", (Object)criteria);
        Page page = this.plantProfitCenterQueryService.findByCriteria(criteria, pageable);
        HttpHeaders headers = PaginationUtil.generatePaginationHttpHeaders((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequest(), (Page)page);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)page.getContent());
    }

    @GetMapping(value={"/plant-profit-centers/{id}"})
    public ResponseEntity<PlantProfitCenterDTO> getPlantProfitCenter(@PathVariable Long id) {
        this.log.debug("REST request to get PlantProfitCenter : {}", (Object)id);
        Optional plantProfitCenterDTO = this.plantProfitCenterService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)plantProfitCenterDTO);
    }

    @DeleteMapping(value={"/plant-profit-centers/{id}"})
    public ResponseEntity<Void> deletePlantProfitCenter(@PathVariable Long id) {
        this.log.debug("REST request to delete PlantProfitCenter : {}", (Object)id);
        this.plantProfitCenterService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }

    @PostMapping(value={"/import/plant-profit-centers"})
    public ResponseEntity<String> importPlantProfitCenterExcelData(@RequestPart(value="file") MultipartFile file) throws IOException {
        String result = this.plantProfitCenterService.importExcelData(file);
        return ResponseEntity.ok().body((Object)result);
    }

    @GetMapping(value={"/plant-profit-centers/count"})
    public ResponseEntity<Long> countPlantProfitCenters(PlantProfitCenterCriteria criteria) {
        this.log.debug("REST request to count PlantProfitCenters by criteria: {}", (Object)criteria);
        return ResponseEntity.ok().body((Object)this.plantProfitCenterQueryService.countByCriteria(criteria));
    }

    @GetMapping(value={"/plant-profit-centers/count/currentMonth"})
    public ResponseEntity<List<GraphResponseDTO>> getCountOfTotalCurrentMonth(@RequestParam String startDate, @RequestParam String endDate, @RequestParam(required=false) String profitCenter, @RequestParam(required=false) List<String> depotName, @RequestParam(required=false) List<String> sbuName) {
        List result = this.plantProfitCenterService.getCountOfCurrentMonth(startDate, endDate, profitCenter, depotName, sbuName);
        return ResponseEntity.ok().body((Object)result);
    }

    @GetMapping(value={"/plant-profit-centers/count/previousMonth"})
    public ResponseEntity<List<GraphResponseDTO>> getCountOfTotalPreviousMonth(@RequestParam String startDate, @RequestParam String endDate, @RequestParam(required=false) String profitCenter, @RequestParam(required=false) List<String> depotName, @RequestParam(required=false) List<String> sbuName) {
        List result = this.plantProfitCenterService.getCountOfPreviousMonth(startDate, endDate, profitCenter, depotName, sbuName);
        return ResponseEntity.ok().body((Object)result);
    }

    @GetMapping(value={"/plant-profit-centers/totalScanned"})
    public ResponseEntity<List<GraphResponseDTO>> getCountOfTotalScanned(@RequestParam String startDate, @RequestParam String endDate, @RequestParam(required=false) String profitCenter, @RequestParam(required=false) List<String> depotName, @RequestParam(required=false) List<String> sbuName) {
        List result = this.plantProfitCenterService.getCountOfTotalScanned(startDate, endDate, profitCenter, depotName, sbuName);
        return ResponseEntity.ok().body((Object)result);
    }

    @GetMapping(value={"/plant-profit-centers/totalUnscanned"})
    public ResponseEntity<List<GraphResponseDTO>> getCountOfTotalUnscanned(@RequestParam String startDate, @RequestParam String endDate, @RequestParam(required=false) String profitCenter, @RequestParam(required=false) List<String> depotName, @RequestParam(required=false) List<String> sbuName) {
        List result = this.plantProfitCenterService.getCountOfTotalUnscanned(startDate, endDate, profitCenter, depotName, sbuName);
        return ResponseEntity.ok().body((Object)result);
    }

    @GetMapping(value={"/plant-profit-centers/graph/allDepotOBDCount"})
    public ResponseEntity<ScanResponseDTO> getCountOfDepotOBD(@RequestParam String startDate, @RequestParam String endDate, @RequestParam(required=false) String profitCenter, @RequestParam(required=false) List<String> depotName, @RequestParam(required=false) List<String> sbuName) {
        ScanResponseDTO result = this.plantProfitCenterService.getDepotOBDCount(startDate, endDate, profitCenter, depotName, sbuName);
        return ResponseEntity.ok().body((Object)result);
    }

    @GetMapping(value={"/plant-profit-centers/graph/overallScanned"})
    public ResponseEntity<List<GraphResponseDTO>> getCountOfOverallScanned(@RequestParam String startDate, @RequestParam String endDate, @RequestParam(required=false) String profitCenter, @RequestParam(required=false) List<String> depotName, @RequestParam(required=false) List<String> sbuName) {
        List result = this.plantProfitCenterService.getOverallScannedCount(startDate, endDate, profitCenter, depotName, sbuName);
        return ResponseEntity.ok().body((Object)result);
    }

    @GetMapping(value={"/plant-profit-centers/graph/overallUnscanned"})
    public ResponseEntity<List<GraphResponseDTO>> getCountOfOverallUnscanned(@RequestParam String startDate, @RequestParam String endDate, @RequestParam(required=false) String profitCenter, @RequestParam(required=false) List<String> depotName, @RequestParam(required=false) List<String> sbuName) {
        List result = this.plantProfitCenterService.getOverallUnscannedCount(startDate, endDate, profitCenter, depotName, sbuName);
        return ResponseEntity.ok().body((Object)result);
    }

    @GetMapping(value={"/plant-profit-centers/graph/obdCount"})
    public ResponseEntity<ScanResponseDTO> getCountOfOBDForProfitCenter(@RequestParam String startDate, @RequestParam String endDate, @RequestParam(required=false) String profitCenter, @RequestParam(required=false) List<String> depotName, @RequestParam(required=false) List<String> sbuName) {
        ScanResponseDTO result = this.plantProfitCenterService.getOBDCountForProfitCenters(startDate, endDate, profitCenter, depotName, sbuName);
        return ResponseEntity.ok().body((Object)result);
    }

    @GetMapping(value={"/plant-profit-centers/graph/scannedVsDispatched"})
    public ResponseEntity<List<GraphResponseDTO>> getScannedVSDispatchedForProfitCenter(@RequestParam String startDate, @RequestParam String endDate, @RequestParam(required=false) String profitCenter, @RequestParam(required=false) List<String> depotName, @RequestParam(required=false) List<String> sbuName) {
        List result = this.plantProfitCenterService.getScannedVSDispatchedForProfitCenter(startDate, endDate, profitCenter, depotName, sbuName);
        return ResponseEntity.ok().body((Object)result);
    }

    @GetMapping(value={"/plant-profit-centers/graph/summaryOfProfitCenter"})
    public ResponseEntity<List<SummaryGraphDTO>> getSummaryForProfitCenter(@RequestParam String startDate, @RequestParam String endDate) {
        List result = this.plantProfitCenterService.getSummaryForProfitCenter(startDate, endDate);
        return ResponseEntity.ok().body((Object)result);
    }

    @GetMapping(value={"/plant-profit-centers/graph/topFiveDepot"})
    public ResponseEntity<ScanResponseDTO> getTopFiveDepot(@RequestParam String startDate, @RequestParam String endDate, @RequestParam(required=false) String profitCenter, @RequestParam(required=false) List<String> depotName, @RequestParam(required=false) List<String> sbuName) {
        ScanResponseDTO result = this.plantProfitCenterService.getTopFiveDepotData(startDate, endDate, profitCenter, depotName, sbuName);
        return ResponseEntity.ok().body((Object)result);
    }

    @GetMapping(value={"/plant-profit-centers/graph/bottomFiveDepot"})
    public ResponseEntity<ScanResponseDTO> getBottomFiveDepot(@RequestParam String startDate, @RequestParam String endDate, @RequestParam(required=false) String profitCenter, @RequestParam(required=false) List<String> depotName, @RequestParam(required=false) List<String> sbuName) {
        ScanResponseDTO result = this.plantProfitCenterService.getBottmFiveDepotData(startDate, endDate, profitCenter, depotName, sbuName);
        return ResponseEntity.ok().body((Object)result);
    }

    @GetMapping(value={"/plant-profit-centers/graph/greaterThanFiftyPercentageNotScanning"})
    public ResponseEntity<ScanResponseDTO> getNotScanningGreaterThanFiftyPercentage(@RequestParam String startDate, @RequestParam String endDate, @RequestParam(required=false) String profitCenter, @RequestParam(required=false) List<String> depotName, @RequestParam(required=false) List<String> sbuName) {
        ScanResponseDTO result = this.plantProfitCenterService.getUnScanningGreaterThanFiftyPercentage(startDate, endDate, profitCenter, depotName, sbuName);
        return ResponseEntity.ok().body((Object)result);
    }

    @GetMapping(value={"/plant-profit-centers/graph/greaterThanTwentyPercentageObdCount"})
    public ResponseEntity<ScanResponseDTO> getOBDCountGreaterThanTwentyPercentage(@RequestParam String startDate, @RequestParam String endDate, @RequestParam(required=false) String profitCenter, @RequestParam(required=false) List<String> depotName, @RequestParam(required=false) List<String> sbuName) {
        ScanResponseDTO result = this.plantProfitCenterService.getObdCountGreaterThanTwentyPercentage(startDate, endDate, profitCenter, depotName, sbuName);
        return ResponseEntity.ok().body((Object)result);
    }

    @GetMapping(value={"/plant-profit-centers/graph/sbuWiseScanning"})
    public ResponseEntity<ScanResponseDTO> getSBUWiseScanning(@RequestParam String startDate, @RequestParam String endDate, @RequestParam(required=false) List<String> depotName, @RequestParam(required=false) List<String> sbuName) {
        ScanResponseDTO result = this.plantProfitCenterService.getWeekAndSbuWiseScanning(startDate, endDate, depotName, sbuName);
        return ResponseEntity.ok().body((Object)result);
    }

    @GetMapping(value={"/plant-profit-centers/graph/scannedAndNotScannedCount"})
    public ResponseEntity<List<GraphResponseDTO>> getCountOfScannedAndNotScanned(@RequestParam String startDate, @RequestParam String endDate, @RequestParam(required=false) String profitCenter, @RequestParam(required=false) List<String> depotName, @RequestParam(required=false) List<String> sbuName) {
        List result = this.plantProfitCenterService.getScannedAndNotScannedData(startDate, endDate, profitCenter, depotName, sbuName);
        return ResponseEntity.ok().body((Object)result);
    }

    @GetMapping(value={"/plant-profit-centers/grid/plantTotalOBD"})
    public ResponseEntity<Page<GridResponseDTO>> getPlantTotalData(Pageable pageable, @RequestParam String startDate, @RequestParam String endDate, @RequestParam(required=false) String profitCenter, @RequestParam(required=false) List<String> depotName, @RequestParam(required=false) List<String> sbuName, @RequestParam(required=false) String query) {
        Page result = this.plantProfitCenterService.getTotalOBDForProfitCenter(startDate, endDate, profitCenter, depotName, sbuName, query, pageable);
        return ResponseEntity.ok().body((Object)result);
    }

    @GetMapping(value={"/plant-profit-centers/list/profitCenters"})
    public ResponseEntity<List<ProfitCenterResponseDTO>> getPlantProfitCentersList() {
        List result = this.plantProfitCenterService.getProfitCentersData();
        return ResponseEntity.ok().body((Object)result);
    }
}

