/*
 * Decompiled with CFR 0.152.
 */
package com.upl.depotdashboard.web.rest;

import com.upl.depotdashboard.security.SecurityUtils;
import com.upl.depotdashboard.security.okta.AuthInfo;
import com.upl.depotdashboard.security.okta.MobileAuthInfo;
import com.upl.depotdashboard.service.AuthenticationService;
import com.upl.depotdashboard.service.dto.AuthenticationDTO;
import com.upl.depotdashboard.service.dto.JWTTokenDTO;
import com.upl.depotdashboard.service.utility.I18nUtility;
import com.upl.depotdashboard.web.rest.errors.BadRequestAlertException;
import com.upl.depotdashboard.web.rest.vm.JWTTokenVM;
import com.upl.depotdashboard.web.rest.vm.LoginVM;
import com.upl.depotdashboard.web.rest.vm.MessageVM;
import com.upl.depotdashboard.web.rest.vm.MobileAuthenticateVM;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class AuthenticationResource {
    private final Logger log = LoggerFactory.getLogger(AuthenticationResource.class);
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    @Autowired
    private I18nUtility i18nUtility;
    private final AuthenticationService authenticationService;

    public AuthenticationResource(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    @PostMapping(value={"/login"})
    public ResponseEntity<JWTTokenDTO> authenticate(@Valid @RequestBody LoginVM loginVM) {
        this.log.debug("REST request to authenticate  : {}", (Object)loginVM);
        JWTTokenDTO jwtTokenDTO = this.authenticationService.authenticate(loginVM.getUsername(), loginVM.getPassword());
        return ResponseEntity.ok().body((Object)jwtTokenDTO);
    }

    @GetMapping(value={"/logout"})
    public ResponseEntity<MessageVM> logout() {
        String token = (String)SecurityUtils.getCurrentUserJWT().get();
        this.log.debug("REST request to logout : {}", (Object)token);
        Boolean result = this.authenticationService.logout(token);
        if (result != null && result.booleanValue()) {
            String message = this.i18nUtility.getMessage("authentication.logout.message", null);
            return ResponseEntity.ok().body((Object)new MessageVM(message));
        }
        String message = this.i18nUtility.getMessage("authentication.logout.token.exception", null);
        throw new BadRequestAlertException(message, "datrixAppUserLogin", "tokennotexists");
    }

    @PostMapping(value={"/authenticate"})
    public ResponseEntity<JWTTokenVM> authenticate(@Valid @RequestBody AuthenticationDTO authenticationDTO) {
        this.log.debug("REST request to authenticate : {}", (Object)authenticationDTO);
        JWTTokenVM jwtTokenVM = new JWTTokenVM(this.authenticationService.authenticate(authenticationDTO));
        return ResponseEntity.ok().body((Object)jwtTokenVM);
    }

    @PostMapping(value={"/mobiles/authenticate"})
    public ResponseEntity<JWTTokenVM> authenticateMobile(@Valid @RequestBody MobileAuthenticateVM mobileAuthenticateVM) {
        this.log.debug("REST request to authenticate mobile user: {}", (Object)mobileAuthenticateVM);
        JWTTokenVM jwtTokenVM = new JWTTokenVM(this.authenticationService.authenticateMobile(mobileAuthenticateVM.getAccessToken()));
        return ResponseEntity.ok().body((Object)jwtTokenVM);
    }

    @GetMapping(value={"/auth-info"})
    public ResponseEntity<AuthInfo> authInfo() {
        this.log.debug("REST request to get authInfo");
        return ResponseEntity.ok().body((Object)this.authenticationService.authInfo());
    }

    @GetMapping(value={"/mobiles/auth-info"})
    public ResponseEntity<MobileAuthInfo> mobileAuthInfo() {
        this.log.debug("REST request to get authInfo");
        return ResponseEntity.ok().body((Object)this.authenticationService.mobileAuthInfo());
    }
}

