/*
 * Decompiled with CFR 0.152.
 */
package com.upl.depotdashboard.web.rest;

import com.upl.depotdashboard.security.SecurityUtils;
import com.upl.depotdashboard.service.AppUserQueryService;
import com.upl.depotdashboard.service.AppUserService;
import com.upl.depotdashboard.service.criteria.AppUserCriteria;
import com.upl.depotdashboard.service.dto.AppUserDTO;
import com.upl.depotdashboard.service.utility.I18nUtility;
import com.upl.depotdashboard.web.rest.errors.BadRequestAlertException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.PaginationUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class AppUserResource {
    private final Logger log = LoggerFactory.getLogger(AppUserResource.class);
    private static final String ENTITY_NAME = "depotdashboardAppUser";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final AppUserService appUserService;
    private final AppUserQueryService appUserQueryService;
    @Autowired
    private I18nUtility i18nUtility;

    public AppUserResource(AppUserService appUserService, AppUserQueryService appUserQueryService) {
        this.appUserService = appUserService;
        this.appUserQueryService = appUserQueryService;
    }

    @PostMapping(value={"/app-users"})
    public ResponseEntity<AppUserDTO> createAppUser(@Valid @RequestBody AppUserDTO appUserDTO) throws URISyntaxException {
        this.log.debug("REST request to save AppUser : {}", (Object)appUserDTO);
        if (appUserDTO.getId() != null) {
            String message = this.i18nUtility.getMessage("appuser.create.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idexists");
        }
        AppUserDTO result = this.appUserService.save(appUserDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/app-users/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/app-users"})
    public ResponseEntity<AppUserDTO> updateAppUser(@Valid @RequestBody AppUserDTO appUserDTO) throws URISyntaxException {
        this.log.debug("REST request to update AppUser : {}", (Object)appUserDTO);
        if (appUserDTO.getId() == null) {
            String message = this.i18nUtility.getMessage("appuser.update.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idnull");
        }
        AppUserDTO result = this.appUserService.save(appUserDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)appUserDTO.getId().toString()))).body((Object)result);
    }

    @PostMapping(value={"/app-users/{id}/profile-image"})
    public ResponseEntity<AppUserDTO> uploadProfileImage(@RequestPart(value="file") MultipartFile file, @PathVariable Long id) throws IOException {
        Long loggedInUserId = Long.parseLong((String)SecurityUtils.getCurrentUserLogin().get());
        if (loggedInUserId.equals(id)) {
            this.log.debug("profile image upload and save for AppUserId : {}", (Object)id);
            AppUserDTO result = this.appUserService.uploadAndSaveProfileImage(id, file);
            return ResponseEntity.ok().body((Object)result);
        }
        String message = this.i18nUtility.getMessage("appuser.image.unauthorized.exception", null);
        throw new BadRequestAlertException(message, ENTITY_NAME, "Unauthorized");
    }

    @GetMapping(value={"/app-users/all"})
    public ResponseEntity<List<AppUserDTO>> getAllAppUsers(AppUserCriteria criteria, Pageable pageable) {
        this.log.debug("REST request to get AppUsers by criteria: {}", (Object)criteria);
        Page page = this.appUserQueryService.findByCriteria(criteria, pageable);
        HttpHeaders headers = PaginationUtil.generatePaginationHttpHeaders((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequest(), (Page)page);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)page.getContent());
    }

    @GetMapping(value={"/app-users/count"})
    public ResponseEntity<Long> countAppUsers(AppUserCriteria criteria) {
        this.log.debug("REST request to count AppUsers by criteria: {}", (Object)criteria);
        return ResponseEntity.ok().body((Object)this.appUserQueryService.countByCriteria(criteria));
    }

    @GetMapping(value={"/app-users"})
    public ResponseEntity<AppUserDTO> getAppUser() {
        Long id = Long.parseLong((String)SecurityUtils.getCurrentUserLogin().get());
        this.log.debug("REST request to get  AppUser : { }", (Object)id);
        Optional appUserDTO = this.appUserService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)appUserDTO);
    }

    @GetMapping(value={"/app-users/{id}"})
    public ResponseEntity<AppUserDTO> getAppUser(@PathVariable Long id) {
        this.log.debug("REST request to get AppUser : {}", (Object)id);
        Optional appUserDTO = this.appUserService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)appUserDTO);
    }

    @DeleteMapping(value={"/app-users/{id}"})
    public ResponseEntity<Void> deleteAppUser(@PathVariable Long id) {
        this.log.debug("REST request to delete AppUser : {}", (Object)id);
        this.appUserService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

