/*
 * Decompiled with CFR 0.152.
 */
package com.upl.depotdashboard.web.rest;

import com.upl.depotdashboard.repository.AppUserLoginRepository;
import com.upl.depotdashboard.service.AppUserLoginService;
import com.upl.depotdashboard.service.dto.AppUserLoginDTO;
import com.upl.depotdashboard.web.rest.errors.BadRequestAlertException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class AppUserLoginResource {
    private final Logger log = LoggerFactory.getLogger(AppUserLoginResource.class);
    private static final String ENTITY_NAME = "depotdashboardAppUserLogin";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final AppUserLoginService appUserLoginService;
    private final AppUserLoginRepository appUserLoginRepository;

    public AppUserLoginResource(AppUserLoginService appUserLoginService, AppUserLoginRepository appUserLoginRepository) {
        this.appUserLoginService = appUserLoginService;
        this.appUserLoginRepository = appUserLoginRepository;
    }

    @PostMapping(value={"/app-user-logins"})
    public ResponseEntity<AppUserLoginDTO> createAppUserLogin(@Valid @RequestBody AppUserLoginDTO appUserLoginDTO) throws URISyntaxException {
        this.log.debug("REST request to save AppUserLogin : {}", (Object)appUserLoginDTO);
        if (appUserLoginDTO.getId() != null) {
            throw new BadRequestAlertException("A new appUserLogin cannot already have an ID", ENTITY_NAME, "idexists");
        }
        AppUserLoginDTO result = this.appUserLoginService.save(appUserLoginDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/app-user-logins/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/app-user-logins/{id}"})
    public ResponseEntity<AppUserLoginDTO> updateAppUserLogin(@PathVariable(value="id", required=false) Long id, @Valid @RequestBody AppUserLoginDTO appUserLoginDTO) throws URISyntaxException {
        this.log.debug("REST request to update AppUserLogin : {}, {}", (Object)id, (Object)appUserLoginDTO);
        if (appUserLoginDTO.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        if (!Objects.equals(id, appUserLoginDTO.getId())) {
            throw new BadRequestAlertException("Invalid ID", ENTITY_NAME, "idinvalid");
        }
        if (!this.appUserLoginRepository.existsById((Object)id)) {
            throw new BadRequestAlertException("Entity not found", ENTITY_NAME, "idnotfound");
        }
        AppUserLoginDTO result = this.appUserLoginService.save(appUserLoginDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)appUserLoginDTO.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/app-user-logins"})
    public List<AppUserLoginDTO> getAllAppUserLogins() {
        this.log.debug("REST request to get all AppUserLogins");
        return this.appUserLoginService.findAll();
    }

    @GetMapping(value={"/app-user-logins/{id}"})
    public ResponseEntity<AppUserLoginDTO> getAppUserLogin(@PathVariable Long id) {
        this.log.debug("REST request to get AppUserLogin : {}", (Object)id);
        Optional appUserLoginDTO = this.appUserLoginService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)appUserLoginDTO);
    }

    @DeleteMapping(value={"/app-user-logins/{id}"})
    public ResponseEntity<Void> deleteAppUserLogin(@PathVariable Long id) {
        this.log.debug("REST request to delete AppUserLogin : {}", (Object)id);
        this.appUserLoginService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

