/*
 * Decompiled with CFR 0.152.
 */
package com.upl.depotdashboard.service.mapper;

import com.upl.depotdashboard.domain.AppUser;
import com.upl.depotdashboard.domain.Country;
import com.upl.depotdashboard.domain.State;
import com.upl.depotdashboard.service.dto.AppUserDTO;
import com.upl.depotdashboard.service.mapper.AppUserMapper;
import com.upl.depotdashboard.service.mapper.CountryMapper;
import com.upl.depotdashboard.service.mapper.StateMapper;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AppUserMapperImpl
implements AppUserMapper {
    @Autowired
    private CountryMapper countryMapper;
    @Autowired
    private StateMapper stateMapper;

    public List<AppUser> toEntity(List<AppUserDTO> dtoList) {
        if (dtoList == null) {
            return null;
        }
        ArrayList<AppUser> list = new ArrayList<AppUser>(dtoList.size());
        for (AppUserDTO appUserDTO : dtoList) {
            list.add(this.toEntity(appUserDTO));
        }
        return list;
    }

    public List<AppUserDTO> toDto(List<AppUser> entityList) {
        if (entityList == null) {
            return null;
        }
        ArrayList<AppUserDTO> list = new ArrayList<AppUserDTO>(entityList.size());
        for (AppUser appUser : entityList) {
            list.add(this.toDto(appUser));
        }
        return list;
    }

    public AppUserDTO toDto(AppUser appUser) {
        if (appUser == null) {
            return null;
        }
        AppUserDTO appUserDTO = new AppUserDTO();
        appUserDTO.setCountryId(this.appUserCountryId(appUser));
        appUserDTO.setStateId(this.appUserStateId(appUser));
        appUserDTO.setMobileNumberCountryId(this.appUserMobileNumberCountryId(appUser));
        appUserDTO.setPhoneCode(this.appUserMobileNumberCountryPhoneCode(appUser));
        appUserDTO.setCountryName(this.appUserCountryName(appUser));
        appUserDTO.setStateName(this.appUserStateName(appUser));
        appUserDTO.setCreatedBy(appUser.getCreatedBy());
        appUserDTO.setCreatedDate(appUser.getCreatedDate());
        appUserDTO.setLastModifiedBy(appUser.getLastModifiedBy());
        appUserDTO.setLastModifiedDate(appUser.getLastModifiedDate());
        appUserDTO.setId(appUser.getId());
        appUserDTO.setEmail(appUser.getEmail());
        appUserDTO.setFirstName(appUser.getFirstName());
        appUserDTO.setLastName(appUser.getLastName());
        appUserDTO.setMobileNumber(appUser.getMobileNumber());
        appUserDTO.setProfilePhotoPath(appUser.getProfilePhotoPath());
        appUserDTO.setRole(appUser.getRole());
        appUserDTO.setStatus(appUser.getStatus());
        appUserDTO.setPincode(appUser.getPincode());
        appUserDTO.setCity(appUser.getCity());
        appUserDTO.setStreet(appUser.getStreet());
        appUserDTO.setLatitude(appUser.getLatitude());
        appUserDTO.setLongitude(appUser.getLongitude());
        appUserDTO.setDistrict(appUser.getDistrict());
        appUserDTO.setFullName(appUser.getFullName());
        return appUserDTO;
    }

    public AppUser toEntity(AppUserDTO appUserDTO) {
        if (appUserDTO == null) {
            return null;
        }
        AppUser appUser = new AppUser();
        appUser.country(this.countryMapper.fromId(appUserDTO.getCountryId()));
        appUser.state(this.stateMapper.fromId(appUserDTO.getStateId()));
        appUser.setMobileNumberCountry(this.countryMapper.fromId(appUserDTO.getMobileNumberCountryId()));
        appUser.setCreatedBy(appUserDTO.getCreatedBy());
        appUser.setCreatedDate(appUserDTO.getCreatedDate());
        appUser.setLastModifiedBy(appUserDTO.getLastModifiedBy());
        appUser.setLastModifiedDate(appUserDTO.getLastModifiedDate());
        appUser.setId(appUserDTO.getId());
        appUser.setEmail(appUserDTO.getEmail());
        appUser.setPassword(appUserDTO.getPassword());
        appUser.setFirstName(appUserDTO.getFirstName());
        appUser.setLastName(appUserDTO.getLastName());
        appUser.setFullName(appUserDTO.getFullName());
        appUser.setMobileNumber(appUserDTO.getMobileNumber());
        appUser.setProfilePhotoPath(appUserDTO.getProfilePhotoPath());
        appUser.setRole(appUserDTO.getRole());
        appUser.setStatus(appUserDTO.getStatus());
        appUser.setPincode(appUserDTO.getPincode());
        appUser.setCity(appUserDTO.getCity());
        appUser.setStreet(appUserDTO.getStreet());
        appUser.setDistrict(appUserDTO.getDistrict());
        appUser.setLatitude(appUserDTO.getLatitude());
        appUser.setLongitude(appUserDTO.getLongitude());
        return appUser;
    }

    private Long appUserCountryId(AppUser appUser) {
        if (appUser == null) {
            return null;
        }
        Country country = appUser.getCountry();
        if (country == null) {
            return null;
        }
        Long id = country.getId();
        if (id == null) {
            return null;
        }
        return id;
    }

    private Long appUserStateId(AppUser appUser) {
        if (appUser == null) {
            return null;
        }
        State state = appUser.getState();
        if (state == null) {
            return null;
        }
        Long id = state.getId();
        if (id == null) {
            return null;
        }
        return id;
    }

    private Long appUserMobileNumberCountryId(AppUser appUser) {
        if (appUser == null) {
            return null;
        }
        Country mobileNumberCountry = appUser.getMobileNumberCountry();
        if (mobileNumberCountry == null) {
            return null;
        }
        Long id = mobileNumberCountry.getId();
        if (id == null) {
            return null;
        }
        return id;
    }

    private Integer appUserMobileNumberCountryPhoneCode(AppUser appUser) {
        if (appUser == null) {
            return null;
        }
        Country mobileNumberCountry = appUser.getMobileNumberCountry();
        if (mobileNumberCountry == null) {
            return null;
        }
        Integer phoneCode = mobileNumberCountry.getPhoneCode();
        if (phoneCode == null) {
            return null;
        }
        return phoneCode;
    }

    private String appUserCountryName(AppUser appUser) {
        if (appUser == null) {
            return null;
        }
        Country country = appUser.getCountry();
        if (country == null) {
            return null;
        }
        String name = country.getName();
        if (name == null) {
            return null;
        }
        return name;
    }

    private String appUserStateName(AppUser appUser) {
        if (appUser == null) {
            return null;
        }
        State state = appUser.getState();
        if (state == null) {
            return null;
        }
        String name = state.getName();
        if (name == null) {
            return null;
        }
        return name;
    }
}

