/*
 * Decompiled with CFR 0.152.
 */
package com.upl.depotdashboard.service.impl;

import com.upl.depotdashboard.domain.State;
import com.upl.depotdashboard.repository.StateRepository;
import com.upl.depotdashboard.service.StateService;
import com.upl.depotdashboard.service.dto.StateDTO;
import com.upl.depotdashboard.service.exception.BadRequestException;
import com.upl.depotdashboard.service.mapper.StateMapper;
import com.upl.depotdashboard.service.utility.I18nUtility;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class StateServiceImpl
implements StateService {
    private final Logger log = LoggerFactory.getLogger(StateServiceImpl.class);
    private final StateRepository stateRepository;
    private final StateMapper stateMapper;
    @Autowired
    private I18nUtility i18nUtility;

    public StateServiceImpl(StateRepository stateRepository, StateMapper stateMapper) {
        this.stateRepository = stateRepository;
        this.stateMapper = stateMapper;
    }

    public StateDTO save(StateDTO stateDTO) {
        this.log.debug("Request to save State : {}", (Object)stateDTO);
        State state = this.stateMapper.toEntity(stateDTO);
        try {
            state = (State)this.stateRepository.save((Object)state);
        }
        catch (Exception e) {
            this.log.debug("State not exist wiht id : " + stateDTO.getId());
            String message = this.i18nUtility.getMessage("state.update.id.exception", null);
            throw new BadRequestException(message);
        }
        return this.stateMapper.toDto(state);
    }

    @Transactional(readOnly=true)
    public List<StateDTO> findAll() {
        this.log.debug("Request to get all States");
        return this.stateRepository.findAll().stream().map(arg_0 -> ((StateMapper)this.stateMapper).toDto(arg_0)).collect(Collectors.toCollection(LinkedList::new));
    }

    @Transactional(readOnly=true)
    public Optional<StateDTO> findOne(Long id) {
        this.log.debug("Request to get State : {}", (Object)id);
        return this.stateRepository.findById((Object)id).map(arg_0 -> ((StateMapper)this.stateMapper).toDto(arg_0));
    }

    public void delete(Long id) {
        this.log.debug("Request to delete State : {}", (Object)id);
        this.stateRepository.deleteById((Object)id);
    }
}

