/*
 * Decompiled with CFR 0.152.
 */
package com.upl.depotdashboard.service.impl;

import com.upl.depotdashboard.domain.CountWithDatesView;
import com.upl.depotdashboard.domain.DepotOBDCountView;
import com.upl.depotdashboard.domain.PlantProfitCenter;
import com.upl.depotdashboard.domain.ScannedUnscannedCountWithDatesView;
import com.upl.depotdashboard.domain.enumeration.CardCount;
import com.upl.depotdashboard.repository.PlantProfitCenterRepository;
import com.upl.depotdashboard.service.PlantProfitCenterService;
import com.upl.depotdashboard.service.dto.GraphResponseDTO;
import com.upl.depotdashboard.service.dto.GridResponseDTO;
import com.upl.depotdashboard.service.dto.PlantProfitCenterDTO;
import com.upl.depotdashboard.service.dto.ProfitCenterResponseDTO;
import com.upl.depotdashboard.service.dto.SbuListDTO;
import com.upl.depotdashboard.service.dto.ScanResponseDTO;
import com.upl.depotdashboard.service.dto.SummaryGraphDTO;
import com.upl.depotdashboard.service.exception.BadRequestException;
import com.upl.depotdashboard.service.mapper.PlantProfitCenterMapper;
import com.upl.depotdashboard.service.utility.I18nUtility;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional
public class PlantProfitCenterServiceImpl
implements PlantProfitCenterService {
    @Autowired
    private I18nUtility i18nUtility;
    private final Logger log = LoggerFactory.getLogger(PlantProfitCenterServiceImpl.class);
    private final PlantProfitCenterRepository plantProfitCenterRepository;
    private final PlantProfitCenterMapper plantProfitCenterMapper;
    private static final Integer NUMBER_OF_DAYS = 7;
    @Value(value="${application.allowed-excel-content-types:}")
    private String allowedExcelContentTypes;

    public PlantProfitCenterServiceImpl(PlantProfitCenterRepository plantProfitCenterRepository, PlantProfitCenterMapper plantProfitCenterMapper) {
        this.plantProfitCenterRepository = plantProfitCenterRepository;
        this.plantProfitCenterMapper = plantProfitCenterMapper;
    }

    public PlantProfitCenterDTO save(PlantProfitCenterDTO plantProfitCenterDTO) {
        this.log.debug("Request to save PlantProfitCenter : {}", (Object)plantProfitCenterDTO);
        PlantProfitCenter plantProfitCenter = (PlantProfitCenter)this.plantProfitCenterMapper.toEntity((Object)plantProfitCenterDTO);
        plantProfitCenter = (PlantProfitCenter)this.plantProfitCenterRepository.save((Object)plantProfitCenter);
        return (PlantProfitCenterDTO)this.plantProfitCenterMapper.toDto((Object)plantProfitCenter);
    }

    @Transactional(readOnly=true)
    public Page<PlantProfitCenterDTO> findAll(Pageable pageable) {
        this.log.debug("Request to get all PlantProfitCenters");
        return this.plantProfitCenterRepository.findAll(pageable).map(arg_0 -> ((PlantProfitCenterMapper)this.plantProfitCenterMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public Optional<PlantProfitCenterDTO> findOne(Long id) {
        this.log.debug("Request to get PlantProfitCenter : {}", (Object)id);
        try {
            return this.plantProfitCenterRepository.findById((Object)id).map(arg_0 -> ((PlantProfitCenterMapper)this.plantProfitCenterMapper).toDto(arg_0));
        }
        catch (Exception e) {
            this.log.debug("Unable to get PlantProfitCente with id: { }", (Object)id);
            String message = this.i18nUtility.getMessage("plantProfitCenter.get.id.exception", null);
            throw new BadRequestException(message);
        }
    }

    public void delete(Long id) {
        this.log.debug("Request to delete PlantProfitCenter : {}", (Object)id);
        try {
            this.plantProfitCenterRepository.deleteById((Object)id);
        }
        catch (Exception e) {
            this.log.debug("PlantProfitCente not exists with id: { }", (Object)id);
            String message = this.i18nUtility.getMessage("plantProfitCenter.delete.id.exception", null);
            throw new BadRequestException(message);
        }
    }

    public String importExcelData(MultipartFile file) throws IOException {
        this.log.debug("Request to Import Data from Excel : {}", (Object)file.getOriginalFilename());
        List<String> allowedTypes = Arrays.asList(this.allowedExcelContentTypes.split(","));
        try {
            if (allowedTypes.contains(file.getContentType())) {
                XSSFWorkbook wb = new XSSFWorkbook(file.getInputStream());
                XSSFSheet sheet = wb.getSheetAt(0);
                DataFormatter formatter = new DataFormatter();
                DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("dd-MMM-yyyy");
                if (sheet.getPhysicalNumberOfRows() == 1) {
                    wb.close();
                    this.log.debug("No data available to import");
                    String message = this.i18nUtility.getMessage("plantProfitCenter.import.data.exception", null);
                    throw new BadRequestException(message);
                }
                for (int index = 1; index < sheet.getPhysicalNumberOfRows(); ++index) {
                    XSSFRow row = sheet.getRow(index);
                    String plantName = formatter.formatCellValue((Cell)row.getCell(0)).trim();
                    String companyName = formatter.formatCellValue((Cell)row.getCell(1)).trim();
                    String companyLocation = formatter.formatCellValue((Cell)row.getCell(2)).trim();
                    String billDocumentNumber = formatter.formatCellValue((Cell)row.getCell(3)).trim();
                    String billCreatedOn = row.getCell(4).toString();
                    String billCreatedTime = formatter.formatCellValue((Cell)row.getCell(5)).trim();
                    String deliveryNumber = formatter.formatCellValue((Cell)row.getCell(6)).trim();
                    String deliveryOn = row.getCell(7).toString();
                    String deliveryTime = formatter.formatCellValue((Cell)row.getCell(8)).trim();
                    String documentDate = row.getCell(9).toString();
                    String documentEntryTime = formatter.formatCellValue((Cell)row.getCell(10)).trim();
                    String documentScannedOn = row.getCell(12).toString();
                    String documentScannedAt = formatter.formatCellValue((Cell)row.getCell(13)).trim();
                    String plantIndicator = formatter.formatCellValue((Cell)row.getCell(14)).trim();
                    String salesOrgnisation = formatter.formatCellValue((Cell)row.getCell(15)).trim();
                    String distributionChannelId = formatter.formatCellValue((Cell)row.getCell(16)).trim();
                    String distributionChannelName = formatter.formatCellValue((Cell)row.getCell(17)).trim();
                    String divisionCode = formatter.formatCellValue((Cell)row.getCell(18)).trim();
                    String targetCode = formatter.formatCellValue((Cell)row.getCell(19)).trim();
                    String targetRetailerName = formatter.formatCellValue((Cell)row.getCell(20)).trim();
                    String billType = formatter.formatCellValue((Cell)row.getCell(21)).trim();
                    String billDate = row.getCell(22).toString();
                    PlantProfitCenter plant = new PlantProfitCenter();
                    plant.setPlantName(plantName);
                    plant.setPlantName(plantName);
                    String cName = companyName.contains("UPL") ? "AF" : (companyName.contains("SWAL") ? "SWAL" : (companyName.contains("Arysta") ? "Arysta" : companyName.trim()));
                    plant.setCompanyName(cName);
                    String cLocation = companyName.contains("-") ? companyName.split("-")[1].trim() : (companyName.contains(",") ? companyName.split(",")[1].trim() : companyLocation.trim());
                    plant.setCompanyLocation(cLocation);
                    plant.setCompanyState(companyLocation);
                    plant.setBillDocumentNumber(Long.valueOf(Long.parseLong(billDocumentNumber)));
                    plant.setBillCreatedOn(LocalDate.parse(billCreatedOn, dateFormatter));
                    plant.setBillCreatedTime(billCreatedTime);
                    plant.setDeliveryNumber(Long.valueOf(Long.parseLong(deliveryNumber)));
                    plant.setDeliveryOn(LocalDate.parse(deliveryOn, dateFormatter));
                    plant.setDeliveryTime(deliveryTime);
                    plant.setDocumentDate(!StringUtils.isBlank((String)documentDate) ? LocalDate.parse(documentDate, dateFormatter) : null);
                    plant.setDocumentEntryTime(documentEntryTime);
                    plant.setDocumentScanStatus(Boolean.valueOf(true));
                    plant.setDocumentScannedOn(!StringUtils.isBlank((String)documentScannedOn) ? LocalDate.parse(documentScannedOn, dateFormatter) : null);
                    plant.setDocumentScannedAt(documentScannedAt);
                    plant.setPlantIndicator(plantIndicator);
                    plant.setSalesOrgnisation(Long.valueOf(Long.parseLong(salesOrgnisation)));
                    plant.setDistributionChannelId(Long.valueOf(Long.parseLong(distributionChannelId)));
                    plant.setDistributionChannelName(distributionChannelName);
                    plant.setDivisionCode(Long.valueOf(Long.parseLong(divisionCode)));
                    plant.setTargetCode(targetCode);
                    plant.targetRetailerName(targetRetailerName);
                    plant.setBillType(billType);
                    plant.setBillDate(LocalDate.parse(billDate, dateFormatter));
                    this.plantProfitCenterRepository.save((Object)plant);
                }
            } else {
                String message = this.i18nUtility.getMessage("plantProfitCenter.import.data.format.error", null);
                return message;
            }
            String message = this.i18nUtility.getMessage("plantProfitCenter.import.data.success", null);
            return message;
        }
        catch (Exception e) {
            this.log.debug("No data available to import");
            String error = this.i18nUtility.getMessage("plantProfitCenter.import.data.failed", null);
            throw new BadRequestException(error);
        }
    }

    private GraphResponseDTO convertIntoGraphResponseDTO(CountWithDatesView value, CardCount type) {
        GraphResponseDTO graphResponseDTO = new GraphResponseDTO();
        graphResponseDTO.setKey(value.getStartDate());
        graphResponseDTO.setValue(value.getCount().toString());
        Float totalCount = Float.valueOf(0.0f);
        Float percentage = Float.valueOf(0.0f);
        if (type.equals((Object)CardCount.SCANNED) || type.equals((Object)CardCount.NOTSCANNED)) {
            totalCount = this.plantProfitCenterRepository.countOfTotal();
            percentage = Float.valueOf((float)value.getCount().longValue() / totalCount.floatValue() * 100.0f);
            graphResponseDTO.setPercentage(String.valueOf((double)Math.round((double)percentage.floatValue() * 100.0) / 100.0));
        }
        return graphResponseDTO;
    }

    private List<GraphResponseDTO> convertIntoGraphResponseDTO(List<CountWithDatesView> list, CardCount type) {
        return list.stream().map(view -> this.convertIntoGraphResponseDTO(view, type)).collect(Collectors.toList());
    }

    private List<GraphResponseDTO> calculateCountForProfitCenter(String fromDate, String toDate, String profitCenter, List<String> depotName, List<String> sbuName, CardCount type) {
        try {
            ArrayList<GraphResponseDTO> graphResponseDTOs = new ArrayList<GraphResponseDTO>();
            Instant sDate = Instant.parse(fromDate.trim() + "T00:00:00.000Z");
            Instant eDate = Instant.parse(toDate.trim() + "T00:00:00.000Z");
            if (type.equals((Object)CardCount.MONTH)) {
                List result = this.plantProfitCenterRepository.countByMonth(profitCenter, depotName != null ? depotName : new ArrayList(), sbuName != null ? sbuName : new ArrayList(), sDate.toString(), eDate.toString(), Boolean.valueOf(true), Boolean.valueOf(depotName != null), Boolean.valueOf(sbuName != null));
                graphResponseDTOs.addAll(this.convertIntoGraphResponseDTO(result, CardCount.MONTH));
            } else if (type.equals((Object)CardCount.SCANNED)) {
                List result = this.plantProfitCenterRepository.countByTotalScanned(profitCenter, depotName != null ? depotName : new ArrayList(), sbuName != null ? sbuName : new ArrayList(), sDate.toString(), eDate.toString(), Boolean.valueOf(true), Boolean.valueOf(depotName != null), Boolean.valueOf(sbuName != null));
                graphResponseDTOs.addAll(this.convertIntoGraphResponseDTO(result, CardCount.SCANNED));
            } else if (type.equals((Object)CardCount.NOTSCANNED)) {
                List result = this.plantProfitCenterRepository.countByTotalUnscanned(profitCenter, depotName != null ? depotName : new ArrayList(), sbuName != null ? sbuName : new ArrayList(), sDate.toString(), eDate.toString(), Boolean.valueOf(true), Boolean.valueOf(depotName != null), Boolean.valueOf(sbuName != null));
                graphResponseDTOs.addAll(this.convertIntoGraphResponseDTO(result, CardCount.NOTSCANNED));
            }
            return graphResponseDTOs;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error("Error occurred while calculating percentage or parsing date");
            String message = this.i18nUtility.getMessage("plantProfitCenter.retrive.data.exception", null);
            throw new BadRequestException(message);
        }
    }

    public List<GraphResponseDTO> getCountOfCurrentMonth(String fromDate, String toDate, String profitCenter, List<String> depotName, List<String> sbuName) {
        this.log.debug("Request to get Count of Current Month from : {} to {}", (Object)fromDate, (Object)toDate);
        List result = this.calculateCountForProfitCenter(fromDate, toDate, profitCenter, depotName, sbuName, CardCount.MONTH);
        return result;
    }

    public List<GraphResponseDTO> getCountOfPreviousMonth(String fromDate, String toDate, String profitCenter, List<String> depotName, List<String> sbuName) {
        this.log.debug("Request to get Count of Previous Month from : {} to {}", (Object)fromDate, (Object)fromDate);
        List result = this.calculateCountForProfitCenter(fromDate, toDate, profitCenter, depotName, sbuName, CardCount.MONTH);
        return result;
    }

    public List<GraphResponseDTO> getCountOfTotalScanned(String fromDate, String toDate, String profitCenter, List<String> depotName, List<String> sbuName) {
        this.log.debug("Request to get Count of Total Scanned Documents from : {} to {}", (Object)fromDate, (Object)fromDate);
        List result = this.calculateCountForProfitCenter(fromDate, toDate, profitCenter, depotName, sbuName, CardCount.SCANNED);
        return result;
    }

    public List<GraphResponseDTO> getCountOfTotalUnscanned(String fromDate, String toDate, String profitCenter, List<String> depotName, List<String> sbuName) {
        this.log.debug("Request to get Count of Total Not Scanned Documents from : {} to {}", (Object)fromDate, (Object)toDate);
        List result = this.calculateCountForProfitCenter(fromDate, toDate, profitCenter, depotName, sbuName, CardCount.NOTSCANNED);
        return result;
    }

    public ScanResponseDTO getDepotOBDCount(String startDate, String endDate, String profitCenter, List<String> depotName, List<String> sbuName) {
        this.log.debug("Request to get Depot OBD Count from : {} to {}", (Object)startDate, (Object)endDate);
        try {
            List depotOBDCount = this.plantProfitCenterRepository.getDepotOBDCount(profitCenter, depotName == null ? new ArrayList() : depotName, sbuName == null ? new ArrayList() : sbuName, startDate, endDate, Boolean.valueOf(true), Boolean.valueOf(depotName != null), Boolean.valueOf(sbuName != null));
            ScanResponseDTO result = this.convertListObjectToDTO(depotOBDCount, profitCenter);
            return result;
        }
        catch (Exception e) {
            this.log.error("Error occurred while getting data from server");
            String message = this.i18nUtility.getMessage("plantProfitCenter.retrive.data.exception", null);
            throw new BadRequestException(message);
        }
    }

    private ScanResponseDTO convertListObjectToDTO(List<DepotOBDCountView> depotOBDCount, String profitCenter) {
        ScanResponseDTO scanResponseDTO = new ScanResponseDTO();
        ArrayList<GraphResponseDTO> scannedList = new ArrayList<GraphResponseDTO>();
        ArrayList<GraphResponseDTO> unScannedList = new ArrayList<GraphResponseDTO>();
        for (DepotOBDCountView object : depotOBDCount) {
            GraphResponseDTO scanned = new GraphResponseDTO();
            GraphResponseDTO unScanned = new GraphResponseDTO();
            if (StringUtils.isBlank((String)profitCenter)) {
                scanned.setKey(object.getCompanyName() + " " + object.getCompanyLocation());
            } else {
                scanned.setKey(object.getCompanyLocation());
            }
            unScanned.setKey(object.getCompanyLocation());
            scanned.setValue(String.valueOf(object.getScannedCount()));
            unScanned.setValue(String.valueOf(object.getUnscannedCount()));
            Float scannedCount = Float.valueOf(Float.parseFloat(String.valueOf(object.getScannedCount())));
            Float unScannedCount = Float.valueOf(Float.parseFloat(String.valueOf(object.getUnscannedCount())));
            String shortName = object.getCompanyName() + " " + (object.getCompanyLocation().length() <= 6 ? object.getCompanyLocation() : object.getCompanyLocation().substring(0, 6));
            scanned.setShortKey(shortName);
            unScanned.setShortKey(shortName);
            Float percentageNotScanned = Float.valueOf(unScannedCount.floatValue() / (scannedCount.floatValue() + unScannedCount.floatValue()) * 100.0f);
            unScanned.setPercentage(String.valueOf((double)Math.round((double)percentageNotScanned.floatValue() * 100.0) / 100.0));
            Float percentageScanned = Float.valueOf(scannedCount.floatValue() / (scannedCount.floatValue() + unScannedCount.floatValue()) * 100.0f);
            scanned.setPercentage(String.valueOf((double)Math.round((double)percentageScanned.floatValue() * 100.0) / 100.0));
            scannedList.add(scanned);
            unScannedList.add(unScanned);
        }
        scanResponseDTO.setScanned(scannedList);
        scanResponseDTO.setUnScanned(unScannedList);
        return scanResponseDTO;
    }

    public List<GraphResponseDTO> getOverallScannedCount(String startDate, String endDate, String profitCenter, List<String> depotName, List<String> sbuName) {
        this.log.debug("Request to get Overall Scanned Documents Count from : {} to {}", (Object)startDate, (Object)endDate);
        try {
            List scannedProfitCenter = this.plantProfitCenterRepository.getOverallScannedForProfitCenter(profitCenter, depotName == null ? new ArrayList() : depotName, sbuName == null ? new ArrayList() : sbuName, startDate, endDate, Boolean.valueOf(true), Boolean.valueOf(depotName != null), Boolean.valueOf(sbuName != null));
            ArrayList<GraphResponseDTO> scannedList = new ArrayList<GraphResponseDTO>();
            Float totalCount = Float.valueOf(0.0f);
            for (Object[] object : scannedProfitCenter) {
                GraphResponseDTO scanned = new GraphResponseDTO();
                scanned.setKey(object[0].toString());
                scanned.setValue(object[1].toString());
                scannedList.add(scanned);
                totalCount = Float.valueOf(totalCount.floatValue() + (float)Long.parseLong(object[1].toString()));
            }
            for (GraphResponseDTO dto : scannedList) {
                Float percentage = Float.valueOf(Float.parseFloat(dto.getValue()) * 100.0f / totalCount.floatValue());
                dto.setPercentage(String.valueOf((double)Math.round((double)percentage.floatValue() * 100.0) / 100.0));
            }
            return scannedList;
        }
        catch (Exception e) {
            this.log.error("Error occurred while getting data from server");
            String message = this.i18nUtility.getMessage("plantProfitCenter.retrive.data.exception", null);
            throw new BadRequestException(message);
        }
    }

    public List<GraphResponseDTO> getOverallUnscannedCount(String startDate, String endDate, String profitCenter, List<String> depotName, List<String> sbuName) {
        this.log.debug("Request to get Overall Not Scanned Documents Count from : {} to {}", (Object)startDate, (Object)endDate);
        try {
            List unScannedProfitCenter = this.plantProfitCenterRepository.getOverallUnscannedForProfitCenter(profitCenter, depotName == null ? new ArrayList() : depotName, sbuName == null ? new ArrayList() : sbuName, startDate, endDate, Boolean.valueOf(true), Boolean.valueOf(depotName != null), Boolean.valueOf(sbuName != null));
            ArrayList<GraphResponseDTO> unScannedList = new ArrayList<GraphResponseDTO>();
            Float totalCount = Float.valueOf(0.0f);
            for (Object[] object : unScannedProfitCenter) {
                GraphResponseDTO unScanned = new GraphResponseDTO();
                unScanned.setKey(object[0].toString());
                unScanned.setValue(object[1].toString());
                unScannedList.add(unScanned);
                totalCount = Float.valueOf(totalCount.floatValue() + Float.parseFloat(object[1].toString()));
            }
            for (GraphResponseDTO dto : unScannedList) {
                Float percentage = Float.valueOf(Float.parseFloat(dto.getValue()) / totalCount.floatValue() * 100.0f);
                dto.setPercentage(String.valueOf((double)Math.round((double)percentage.floatValue() * 100.0) / 100.0));
            }
            return unScannedList;
        }
        catch (Exception e) {
            this.log.error("Error occurred while getting data from server");
            String message = this.i18nUtility.getMessage("plantProfitCenter.retrive.data.exception", null);
            throw new BadRequestException(message);
        }
    }

    public ScanResponseDTO getOBDCountForProfitCenters(String fromDate, String toDate, String profitCenter, List<String> depotName, List<String> sbuName) {
        this.log.debug("Request to get OBD Count For Profit Center from : {} to {}", (Object)fromDate, (Object)toDate);
        try {
            ScanResponseDTO scanResponseDTO = new ScanResponseDTO();
            ArrayList<GraphResponseDTO> scanned = new ArrayList<GraphResponseDTO>();
            ArrayList<GraphResponseDTO> unScanned = new ArrayList<GraphResponseDTO>();
            Instant sDate = Instant.parse(fromDate.trim() + "T00:00:00.000Z");
            Instant eDate = Instant.parse(toDate.trim() + "T00:00:00.000Z");
            Float totalScanned = Float.valueOf(0.0f);
            Float totalUnscanned = Float.valueOf(0.0f);
            List depotOBDCount = this.plantProfitCenterRepository.getOBDCountForProfitCenter(profitCenter, depotName == null ? new ArrayList() : depotName, sbuName == null ? new ArrayList() : sbuName, sDate.toString(), eDate.toString(), Boolean.valueOf(true), Boolean.valueOf(depotName != null), Boolean.valueOf(sbuName != null));
            for (ScannedUnscannedCountWithDatesView object : depotOBDCount) {
                scanned.add(this.getGraphResponseDTO(object.getStartDate(), object.getScannedCount().toString(), null));
                unScanned.add(this.getGraphResponseDTO(object.getStartDate(), object.getUnscannedCount().toString(), null));
                totalScanned = Float.valueOf(totalScanned.floatValue() + Float.parseFloat(object.getScannedCount().toString()));
                totalUnscanned = Float.valueOf(totalUnscanned.floatValue() + Float.parseFloat(object.getUnscannedCount().toString()));
            }
            Float finalTotalScanned = totalScanned;
            Float finalTotalUnscanned = totalUnscanned;
            scanned.forEach(graphResponseDTO -> {
                Float percentage = Float.valueOf(Float.parseFloat(graphResponseDTO.getValue()) / (finalTotalScanned.floatValue() + finalTotalUnscanned.floatValue()) * 100.0f);
                graphResponseDTO.setPercentage(String.valueOf((double)Math.round((double)percentage.floatValue() * 100.0) / 100.0));
            });
            unScanned.forEach(graphResponseDTO -> {
                Float percentage = Float.valueOf(Float.parseFloat(graphResponseDTO.getValue()) / (finalTotalScanned.floatValue() + finalTotalUnscanned.floatValue()) * 100.0f);
                graphResponseDTO.setPercentage(String.valueOf((double)Math.round((double)percentage.floatValue() * 100.0) / 100.0));
            });
            scanResponseDTO.setScanned(scanned);
            scanResponseDTO.setUnScanned(unScanned);
            return scanResponseDTO;
        }
        catch (Exception e) {
            this.log.error("Error occurred while calculating percentage or parsing date");
            String message = this.i18nUtility.getMessage("plantProfitCenter.retrive.data.exception", null);
            throw new BadRequestException(message);
        }
    }

    private GraphResponseDTO getGraphResponseDTO(String key, String value, String percentage) {
        GraphResponseDTO dto = new GraphResponseDTO();
        dto.setKey(key);
        dto.setValue(value);
        dto.setPercentage(percentage);
        return dto;
    }

    public List<GraphResponseDTO> getScannedVSDispatchedForProfitCenter(String startDate, String endDate, String profitCenter, List<String> depotName, List<String> sbuName) {
        this.log.debug("Request to get Scanned Vs Dispatched Data For Profit Center from : {} to {}", (Object)startDate, (Object)endDate);
        try {
            ArrayList<GraphResponseDTO> result = new ArrayList<GraphResponseDTO>();
            List profitCenters = this.plantProfitCenterRepository.getScannedAndTotalCountForProfitCenter(profitCenter, depotName == null ? new ArrayList() : depotName, sbuName == null ? new ArrayList() : sbuName, startDate, endDate, Boolean.valueOf(true), Boolean.valueOf(depotName != null), Boolean.valueOf(sbuName != null));
            GraphResponseDTO responseDTO = null;
            Object[] objects = (Object[])profitCenters.get(0);
            Double totalCount = Double.parseDouble(objects[0].toString());
            Double scannedCount = Double.parseDouble(objects[1].toString());
            Double scannedPercentage = scannedCount / totalCount * 100.0;
            responseDTO = new GraphResponseDTO();
            responseDTO.setKey("scannedPercentage");
            responseDTO.setValue(scannedCount.toString());
            responseDTO.setPercentage(String.valueOf((double)Math.round(scannedPercentage * 100.0) / 100.0));
            result.add(responseDTO);
            responseDTO = new GraphResponseDTO();
            responseDTO.setKey("notScannedPercentage");
            responseDTO.setValue(String.valueOf(totalCount - scannedCount));
            responseDTO.setPercentage(String.valueOf((double)Math.round((100.0 - scannedPercentage) * 100.0) / 100.0));
            result.add(responseDTO);
            return result;
        }
        catch (Exception e) {
            this.log.error("Error occurred while getting data from server");
            String message = this.i18nUtility.getMessage("plantProfitCenter.retrive.data.exception", null);
            throw new BadRequestException(message);
        }
    }

    public Page<GridResponseDTO> getTotalOBDForProfitCenter(String startDate, String endDate, String profitCenter, List<String> depotName, List<String> sbuName, String query, Pageable pageable) {
        this.log.debug("Request to get Total OBD For Profit Center from : {} to {}", (Object)startDate, (Object)endDate);
        try {
            List profitCenters = this.plantProfitCenterRepository.getTotalOBDForProfitCenter(profitCenter, depotName == null ? new ArrayList() : depotName, sbuName == null ? new ArrayList() : sbuName, startDate, endDate, query != null ? query : "", Boolean.valueOf(true), Boolean.valueOf(depotName != null), Boolean.valueOf(sbuName != null));
            List result = this.convertObjectToGridResponseDTO(profitCenters);
            int start = (int)pageable.getOffset();
            int end = start + pageable.getPageSize() > result.size() ? result.size() : start + pageable.getPageSize();
            return new PageImpl(result.subList(start, end), pageable, (long)result.size());
        }
        catch (Exception e) {
            this.log.error("Error occurred while getting data from server");
            String message = this.i18nUtility.getMessage("plantProfitCenter.retrive.data.exception", null);
            throw new BadRequestException(message);
        }
    }

    private List<GridResponseDTO> convertObjectToGridResponseDTO(List<Object[]> objects) {
        ArrayList<GridResponseDTO> result = new ArrayList<GridResponseDTO>();
        Float total = Float.valueOf(0.0f);
        Float value = Float.valueOf(0.0f);
        Float percentage = Float.valueOf(0.0f);
        for (Object[] object : objects) {
            GridResponseDTO gridResponseDTO = new GridResponseDTO();
            gridResponseDTO.setProfitCenter(object[0].toString());
            gridResponseDTO.setDepot(object[1].toString());
            gridResponseDTO.setTotalCount(object[2].toString());
            gridResponseDTO.setCountOfScanned(object[3].toString());
            gridResponseDTO.setCountOfUnscanned(object[4].toString());
            gridResponseDTO.setSbu(object[5] != null ? object[5].toString() : null);
            total = Float.valueOf(Float.parseFloat(object[2].toString()));
            value = Float.valueOf(Float.parseFloat(object[3].toString()));
            percentage = Float.valueOf(value.floatValue() / total.floatValue() * 100.0f);
            gridResponseDTO.setPercentageOfScanned(String.valueOf((double)Math.round((double)percentage.floatValue() * 100.0) / 100.0));
            value = Float.valueOf(Float.parseFloat(object[4].toString()));
            percentage = Float.valueOf(value.floatValue() / total.floatValue() * 100.0f);
            gridResponseDTO.setPercentageOfUnscanned(String.valueOf((double)Math.round((double)percentage.floatValue() * 100.0) / 100.0));
            result.add(gridResponseDTO);
        }
        return result;
    }

    public List<ProfitCenterResponseDTO> getProfitCentersData() {
        this.log.debug("Request to get Profit Centers List ");
        try {
            ArrayList<ProfitCenterResponseDTO> profitCenterDTO = new ArrayList<ProfitCenterResponseDTO>();
            List objects = this.plantProfitCenterRepository.getProfitCentersData();
            List<Object> profitCenters = new ArrayList<String>();
            List<Object> sbus = new ArrayList();
            for (Object[] objectArray : objects) {
                profitCenters.add(objectArray[0].toString());
                if (objectArray[1] == null) continue;
                sbus.add(objectArray[1].toString());
            }
            profitCenters = profitCenters.stream().distinct().collect(Collectors.toList());
            sbus = sbus.stream().distinct().collect(Collectors.toList());
            for (String string : profitCenters) {
                ProfitCenterResponseDTO profitCenterResponseDTO = new ProfitCenterResponseDTO();
                ArrayList<SbuListDTO> sbuListDTOs = new ArrayList<SbuListDTO>();
                for (String string2 : sbus) {
                    ArrayList<String> sbuDepotList = new ArrayList<String>();
                    ArrayList<String> nonSbuDepotList = new ArrayList<String>();
                    SbuListDTO sbuListDTO = new SbuListDTO();
                    for (Object[] object : objects) {
                        String sbuName;
                        String string3 = sbuName = object[1] != null ? object[1].toString() : "";
                        if (string.equals(object[0].toString()) && string2.equals(sbuName)) {
                            sbuDepotList.add(object[2].toString());
                            continue;
                        }
                        if (!string.equals(object[0].toString()) || !StringUtils.isEmpty((String)sbuName)) continue;
                        nonSbuDepotList.add(object[2].toString());
                    }
                    if (!sbuDepotList.isEmpty()) {
                        sbuListDTO.setSbuName(string2);
                        sbuListDTO.setDepotName(sbuDepotList);
                        sbuListDTOs.add(sbuListDTO);
                        continue;
                    }
                    if (nonSbuDepotList.isEmpty()) continue;
                    sbuListDTO.setSbuName(null);
                    sbuListDTO.setDepotName(nonSbuDepotList);
                    sbuListDTOs.add(sbuListDTO);
                    break;
                }
                profitCenterResponseDTO.setProfitCenter(string);
                profitCenterResponseDTO.setSbuListDTO(sbuListDTOs);
                profitCenterDTO.add(profitCenterResponseDTO);
            }
            return profitCenterDTO;
        }
        catch (Exception e) {
            this.log.error("Error occurred while getting data from server");
            String message = this.i18nUtility.getMessage("plantProfitCenter.retrive.data.exception", null);
            throw new BadRequestException(message);
        }
    }

    public List<SummaryGraphDTO> getSummaryForProfitCenter(String startDate, String endDate) {
        this.log.debug("Request to get Summary For Profit Centers of Date Range from : {} to {}", (Object)startDate, (Object)endDate);
        try {
            ArrayList<SummaryGraphDTO> result = new ArrayList<SummaryGraphDTO>();
            List objects = this.plantProfitCenterRepository.getSummaryForProfitCenter(startDate, endDate);
            Float total = Float.valueOf(0.0f);
            Float scanned = Float.valueOf(0.0f);
            Float notScanned = Float.valueOf(0.0f);
            Float percentage = Float.valueOf(0.0f);
            for (Object[] object : objects) {
                SummaryGraphDTO summaryGraphDTO = new SummaryGraphDTO();
                summaryGraphDTO.setCompanyName(object[0].toString());
                total = Float.valueOf(Float.parseFloat(object[1].toString()));
                scanned = Float.valueOf(Float.parseFloat(object[2].toString()));
                notScanned = Float.valueOf(Float.parseFloat(object[3].toString()));
                summaryGraphDTO.setTotalCount(object[1].toString());
                percentage = Float.valueOf(scanned.floatValue() / total.floatValue() * 100.0f);
                summaryGraphDTO.setScannedPercentage(String.valueOf((double)Math.round((double)percentage.floatValue() * 100.0) / 100.0));
                percentage = Float.valueOf(notScanned.floatValue() / total.floatValue() * 100.0f);
                summaryGraphDTO.setUnScannedPercentage(String.valueOf((double)Math.round((double)percentage.floatValue() * 100.0) / 100.0));
                result.add(summaryGraphDTO);
            }
            return result;
        }
        catch (Exception e) {
            this.log.error("Error occurred while getting data from server");
            String message = this.i18nUtility.getMessage("plantProfitCenter.retrive.data.exception", null);
            throw new BadRequestException(message);
        }
    }

    public ScanResponseDTO getTopFiveDepotData(String startDate, String endDate, String profitCenter, List<String> depotName, List<String> sbuName) {
        this.log.debug("Request to get Top 5 Depot from : {} to {}", (Object)startDate, (Object)endDate);
        try {
            List objects = this.plantProfitCenterRepository.getTopFiveDepot(profitCenter, depotName == null ? new ArrayList() : depotName, sbuName == null ? new ArrayList() : sbuName, startDate, endDate, Boolean.valueOf(true), Boolean.valueOf(depotName != null), Boolean.valueOf(sbuName != null));
            ScanResponseDTO scanResponseDTO = this.convertListObjectToDTO(objects, profitCenter);
            return scanResponseDTO;
        }
        catch (Exception e) {
            this.log.error("Error occurred while getting data from server");
            String message = this.i18nUtility.getMessage("plantProfitCenter.retrive.data.exception", null);
            throw new BadRequestException(message);
        }
    }

    public ScanResponseDTO getBottmFiveDepotData(String startDate, String endDate, String profitCenter, List<String> depotName, List<String> sbuName) {
        this.log.debug("Request to get Bottom 5 Depot from : {} to {}", (Object)startDate, (Object)endDate);
        try {
            List objects = this.plantProfitCenterRepository.getBottomFiveDepot(profitCenter, depotName == null ? new ArrayList() : depotName, sbuName == null ? new ArrayList() : sbuName, startDate, endDate, Boolean.valueOf(true), Boolean.valueOf(depotName != null), Boolean.valueOf(sbuName != null));
            ScanResponseDTO scanResponseDTO = this.convertListObjectToDTO(objects, profitCenter);
            return scanResponseDTO;
        }
        catch (Exception e) {
            this.log.error("Error occurred while getting data from server");
            String message = this.i18nUtility.getMessage("plantProfitCenter.retrive.data.exception", null);
            throw new BadRequestException(message);
        }
    }

    public ScanResponseDTO getUnScanningGreaterThanFiftyPercentage(String startDate, String endDate, String profitCenter, List<String> depotName, List<String> sbuName) {
        this.log.debug("Request to get Scanning Greater Than Fifty Percentage Depot from : {} to {}", (Object)startDate, (Object)endDate);
        ScanResponseDTO result = this.convertIntoScanResponseDTO(startDate, endDate, profitCenter, depotName, sbuName, CardCount.FIFTYPERCENTAGENOTSCANNED);
        return result;
    }

    public ScanResponseDTO getObdCountGreaterThanTwentyPercentage(String startDate, String endDate, String profitCenter, List<String> depotName, List<String> sbuName) {
        this.log.debug("Request to get Depot Count Greater Than Twenty from : {} to {}", (Object)startDate, (Object)endDate);
        ScanResponseDTO result = this.convertIntoScanResponseDTO(startDate, endDate, profitCenter, depotName, sbuName, CardCount.TWENTYDEPOTCOUNT);
        return result;
    }

    public ScanResponseDTO getWeekAndSbuWiseScanning(String fromDate, String toDate, List<String> depotName, List<String> sbuName) {
        ScanResponseDTO result = this.convertIntoScanResponseDTO(fromDate, toDate, null, depotName, sbuName, CardCount.WEEKWISESCANNING);
        return result;
    }

    public List<GraphResponseDTO> getScannedAndNotScannedData(String startDate, String endDate, String profitCenter, List<String> depotName, List<String> sbuName) {
        this.log.debug("Request to get Scanned Vs Not Scanned Data For Profit Center from : {} to {}", (Object)startDate, (Object)endDate);
        try {
            ArrayList<GraphResponseDTO> result = new ArrayList<GraphResponseDTO>();
            List profitCenters = this.plantProfitCenterRepository.countByTotalScannedAndUnscanned(profitCenter, depotName == null ? new ArrayList() : depotName, sbuName == null ? new ArrayList() : sbuName, startDate, endDate, Boolean.valueOf(true), Boolean.valueOf(depotName != null), Boolean.valueOf(sbuName != null));
            Double percentage = 0.0;
            GraphResponseDTO responseDTO = null;
            Object[] objects = (Object[])profitCenters.get(0);
            Double scannedCount = Double.parseDouble(objects[0].toString());
            Double unscannedCount = Double.parseDouble(objects[1].toString());
            percentage = scannedCount / (scannedCount + unscannedCount) * 100.0;
            responseDTO = new GraphResponseDTO();
            responseDTO.setKey("scannedPercentage");
            responseDTO.setValue(scannedCount.toString());
            responseDTO.setPercentage(String.valueOf((double)Math.round(percentage * 100.0) / 100.0));
            result.add(responseDTO);
            percentage = unscannedCount / (scannedCount + unscannedCount) * 100.0;
            responseDTO = new GraphResponseDTO();
            responseDTO.setKey("notScannedPercentage");
            responseDTO.setValue(String.valueOf(unscannedCount));
            responseDTO.setPercentage(String.valueOf((double)Math.round(percentage * 100.0) / 100.0));
            result.add(responseDTO);
            return result;
        }
        catch (Exception e) {
            this.log.error("Error occurred while getting data from server");
            String message = this.i18nUtility.getMessage("plantProfitCenter.retrive.data.exception", null);
            throw new BadRequestException(message);
        }
    }

    private ScanResponseDTO convertIntoScanResponseDTO(String fromDate, String toDate, String profitCenter, List<String> depotName, List<String> sbuName, CardCount cardCount) {
        try {
            ScanResponseDTO scanResponseDTO = new ScanResponseDTO();
            ArrayList<GraphResponseDTO> scanned = new ArrayList<GraphResponseDTO>();
            ArrayList<GraphResponseDTO> unScanned = new ArrayList<GraphResponseDTO>();
            Instant sDate = Instant.parse(fromDate.trim() + "T00:00:00.000Z");
            Instant eDate = Instant.parse(toDate.trim() + "T00:00:00.000Z");
            Float scannedCount = Float.valueOf(0.0f);
            Float unscannedCount = Float.valueOf(0.0f);
            Float percentageNotScanned = Float.valueOf(0.0f);
            Float percentageScanned = Float.valueOf(0.0f);
            List result = null;
            if (cardCount.equals((Object)CardCount.WEEKWISESCANNING)) {
                result = this.plantProfitCenterRepository.getSbuWiseScanning("AF", depotName == null ? new ArrayList() : depotName, sbuName == null ? new ArrayList() : sbuName, sDate.toString(), eDate.toString(), Boolean.valueOf(true), Boolean.valueOf(depotName != null), Boolean.valueOf(sbuName != null));
            } else if (cardCount.equals((Object)CardCount.TWENTYDEPOTCOUNT)) {
                result = this.plantProfitCenterRepository.getGetCountByWeek(profitCenter, depotName == null ? new ArrayList() : depotName, sbuName == null ? new ArrayList() : sbuName, sDate.toString(), eDate.toString(), Boolean.valueOf(true), Boolean.valueOf(depotName != null), Boolean.valueOf(sbuName != null));
            } else if (cardCount.equals((Object)CardCount.FIFTYPERCENTAGENOTSCANNED)) {
                result = this.plantProfitCenterRepository.getGetCountByWeek(profitCenter, depotName == null ? new ArrayList() : depotName, sbuName == null ? new ArrayList() : sbuName, sDate.toString(), eDate.toString(), Boolean.valueOf(true), Boolean.valueOf(depotName != null), Boolean.valueOf(sbuName != null));
            }
            for (ScannedUnscannedCountWithDatesView row : result) {
                scannedCount = Float.valueOf(Float.parseFloat(row.getScannedCount().toString()));
                unscannedCount = Float.valueOf(Float.parseFloat(row.getUnscannedCount().toString()));
                percentageNotScanned = Float.valueOf(unscannedCount.floatValue() / (scannedCount.floatValue() + unscannedCount.floatValue()) * 100.0f);
                percentageScanned = Float.valueOf(scannedCount.floatValue() / (scannedCount.floatValue() + unscannedCount.floatValue()) * 100.0f);
                if (percentageScanned.isNaN()) {
                    percentageScanned = Float.valueOf(0.0f);
                }
                if (percentageNotScanned.isNaN()) {
                    percentageNotScanned = Float.valueOf(0.0f);
                }
                if (cardCount.equals((Object)CardCount.TWENTYDEPOTCOUNT)) {
                    if (!(scannedCount.floatValue() + unscannedCount.floatValue() > 20.0f)) continue;
                    scanned.add(this.getGraphResponseDTO(row.getStartDate(), scannedCount.toString(), percentageScanned.toString()));
                    unScanned.add(this.getGraphResponseDTO(row.getStartDate(), unscannedCount.toString(), percentageNotScanned.toString()));
                    continue;
                }
                if (cardCount.equals((Object)CardCount.FIFTYPERCENTAGENOTSCANNED)) {
                    if (!(percentageNotScanned.floatValue() > 50.0f)) continue;
                    scanned.add(this.getGraphResponseDTO(row.getStartDate(), scannedCount.toString(), percentageScanned.toString()));
                    unScanned.add(this.getGraphResponseDTO(row.getStartDate(), unscannedCount.toString(), percentageNotScanned.toString()));
                    continue;
                }
                scanned.add(this.getGraphResponseDTO(row.getStartDate(), scannedCount.toString(), percentageScanned.toString()));
                unScanned.add(this.getGraphResponseDTO(row.getStartDate(), unscannedCount.toString(), percentageNotScanned.toString()));
            }
            scanResponseDTO.setScanned(scanned);
            scanResponseDTO.setUnScanned(unScanned);
            return scanResponseDTO;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error("Error occurred while calculating percentage or parsing date");
            String message = this.i18nUtility.getMessage("plantProfitCenter.retrive.data.exception", null);
            throw new BadRequestException(message);
        }
    }
}

