/*
 * Decompiled with CFR 0.152.
 */
package com.upl.depotdashboard.service.impl;

import com.upl.depotdashboard.domain.Country;
import com.upl.depotdashboard.repository.CountryRepository;
import com.upl.depotdashboard.service.CountryService;
import com.upl.depotdashboard.service.dto.CountryDTO;
import com.upl.depotdashboard.service.exception.BadRequestException;
import com.upl.depotdashboard.service.mapper.CountryMapper;
import com.upl.depotdashboard.service.utility.I18nUtility;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CountryServiceImpl
implements CountryService {
    private final Logger log = LoggerFactory.getLogger(CountryServiceImpl.class);
    private final CountryRepository countryRepository;
    private final CountryMapper countryMapper;
    @Autowired
    private I18nUtility i18nUtility;

    public CountryServiceImpl(CountryRepository countryRepository, CountryMapper countryMapper) {
        this.countryRepository = countryRepository;
        this.countryMapper = countryMapper;
    }

    public CountryDTO save(CountryDTO countryDTO) {
        this.log.debug("Request to save Country : {}", (Object)countryDTO);
        Country country = (Country)this.countryMapper.toEntity((Object)countryDTO);
        try {
            country = (Country)this.countryRepository.save((Object)country);
        }
        catch (Exception e) {
            this.log.debug("Country not exist wiht id : " + countryDTO.getId());
            String message = this.i18nUtility.getMessage("country.update.id.exception", null);
            throw new BadRequestException(message);
        }
        return (CountryDTO)this.countryMapper.toDto((Object)country);
    }

    @Transactional(readOnly=true)
    public List<CountryDTO> findAll() {
        this.log.debug("Request to get all Countries");
        return this.countryRepository.findAll().stream().map(arg_0 -> ((CountryMapper)this.countryMapper).toDto(arg_0)).collect(Collectors.toCollection(LinkedList::new));
    }

    @Transactional(readOnly=true)
    public Optional<CountryDTO> findOne(Long id) {
        this.log.debug("Request to get Country : {}", (Object)id);
        return this.countryRepository.findById((Object)id).map(arg_0 -> ((CountryMapper)this.countryMapper).toDto(arg_0));
    }

    public void delete(Long id) {
        this.log.debug("Request to delete Country : {}", (Object)id);
        this.countryRepository.deleteById((Object)id);
    }
}

