/*
 * Decompiled with CFR 0.152.
 */
package com.upl.depotdashboard.service.impl;

import com.upl.depotdashboard.domain.AppUser;
import com.upl.depotdashboard.domain.AppUserLogin;
import com.upl.depotdashboard.repository.AppUserLoginRepository;
import com.upl.depotdashboard.repository.AppUserRepository;
import com.upl.depotdashboard.security.jwt.TokenProvider;
import com.upl.depotdashboard.security.okta.AuthInfo;
import com.upl.depotdashboard.security.okta.MobileAuthInfo;
import com.upl.depotdashboard.security.okta.OktaSecurity;
import com.upl.depotdashboard.security.okta.OktaUser;
import com.upl.depotdashboard.service.AuthenticationService;
import com.upl.depotdashboard.service.dto.AuthenticationDTO;
import com.upl.depotdashboard.service.dto.JWTTokenDTO;
import com.upl.depotdashboard.service.exception.BadRequestException;
import com.upl.depotdashboard.service.utility.I18nUtility;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.RestClientException;

@Service
@Transactional
public class AuthenticationServiceImpl
implements AuthenticationService {
    private final Logger log = LoggerFactory.getLogger(AuthenticationServiceImpl.class);
    private final AppUserRepository appUserRepository;
    private final AppUserLoginRepository appUserLoginRepository;
    @Autowired
    private TokenProvider tokenProvider;
    @Autowired
    private I18nUtility i18nUtility;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private OktaSecurity oktaSecurity;

    public AuthenticationServiceImpl(AppUserRepository appUserRepository, AppUserLoginRepository appUserLoginRepository) {
        this.appUserRepository = appUserRepository;
        this.appUserLoginRepository = appUserLoginRepository;
    }

    public Boolean logout(String token) {
        Optional appUserLogin = this.appUserLoginRepository.findByToken(token);
        if (appUserLogin.isPresent()) {
            AppUserLogin updateAppUserLogin = (AppUserLogin)appUserLogin.get();
            updateAppUserLogin.setLogoutDate(Instant.now());
            this.appUserLoginRepository.save((Object)updateAppUserLogin);
            return true;
        }
        this.log.debug("Unable to find user login token");
        return false;
    }

    public JWTTokenDTO authenticate(String username, String password) {
        Optional appUser = this.appUserRepository.findByEmail(username);
        JWTTokenDTO tokenDTO = null;
        if (appUser.isPresent()) {
            tokenDTO = this.authenticateUser(appUser, password);
        }
        return tokenDTO;
    }

    private JWTTokenDTO authenticateUser(Optional<AppUser> appUser, String password) {
        if (appUser.isPresent() && appUser.get().isStatus().booleanValue()) {
            AppUser user = appUser.get();
            String hashPassword = this.passwordEncoder.encode((CharSequence)password);
            this.log.debug("password : {}", (Object)hashPassword);
            if (this.passwordEncoder.matches((CharSequence)password, user.getPassword())) {
                this.log.debug("User is present {}", (Object)user);
                JWTTokenDTO jwtTokenDTO = new JWTTokenDTO();
                jwtTokenDTO.setToken(this.getToken(user));
                return jwtTokenDTO;
            }
            this.log.debug("User password combination not match.");
            String message = this.i18nUtility.getMessage("authentication.authenticate.user.invalid.password.exception", null);
            throw new BadRequestException(message);
        }
        this.log.debug("User is not found.");
        String message = this.i18nUtility.getMessage("authentication.authenticate.user.invalid.password.exception", null);
        throw new BadRequestException(message);
    }

    public AuthInfo authInfo() {
        return this.oktaSecurity.getAuthInfo();
    }

    public MobileAuthInfo mobileAuthInfo() {
        return this.oktaSecurity.getMobileAuthInfo();
    }

    public String authenticate(AuthenticationDTO authenticationDTO) {
        this.log.debug("code : {}", (Object)authenticationDTO);
        try {
            OktaUser oktaUser = this.oktaSecurity.authenticate(authenticationDTO.getCode());
            String email = oktaUser.getEmail();
            String preferredUsername = oktaUser.getPreferred_username();
            this.log.debug("oktaUser=> email: {} , preferredUsername: {}", (Object)email, (Object)preferredUsername);
            Optional appUser = this.appUserRepository.findByEmail(preferredUsername);
            if (!appUser.isPresent()) {
                appUser = this.appUserRepository.findByEmail(email);
            }
            if (appUser.isPresent() && ((AppUser)appUser.get()).isStatus().booleanValue()) {
                String token = this.getToken((AppUser)appUser.get());
                this.log.debug("token : { }", (Object)token);
                return token;
            }
            this.log.debug("User is not found.");
            String message = this.i18nUtility.getMessage("authentication.authenticate.user.invalid.password.exception", null);
            throw new BadRequestException(message);
        }
        catch (RestClientException ex) {
            throw new BadRequestException(ex.getMessage());
        }
    }

    public String authenticateMobile(String accessToken) {
        try {
            OktaUser oktaUser = this.oktaSecurity.authenticateMobile(accessToken);
            String email = oktaUser.getEmail();
            String preferredUsername = oktaUser.getPreferred_username();
            this.log.debug("oktaUser=> email: {} , preferredUsername: {}", (Object)email, (Object)preferredUsername);
            Optional appUser = this.appUserRepository.findByEmail(preferredUsername);
            if (!appUser.isPresent()) {
                appUser = this.appUserRepository.findByEmail(email);
            }
            if (appUser.isPresent() && ((AppUser)appUser.get()).isStatus().booleanValue()) {
                return this.getToken((AppUser)appUser.get());
            }
            this.log.debug("User is not present");
            String message = this.i18nUtility.getMessage("authentication.authenticate.user.invalid.password.exception", null);
            throw new BadRequestException(message);
        }
        catch (RestClientException ex) {
            throw new BadRequestException(ex.getMessage());
        }
    }

    private String getToken(AppUser user) {
        if (user.isStatus().booleanValue()) {
            ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
            SimpleGrantedAuthority authority = new SimpleGrantedAuthority(user.getRole().name());
            authorities.add(authority);
            UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)user.getId(), (Object)user.getEmail(), authorities);
            String token = this.tokenProvider.createToken((Authentication)authentication);
            AppUserLogin appUserLogin = new AppUserLogin();
            appUserLogin.setAppUser(user);
            appUserLogin.setLoginDate(Instant.now());
            appUserLogin.setToken(token);
            this.appUserLoginRepository.save((Object)appUserLogin);
            return token;
        }
        this.log.debug("User is present but inactive throw AuthenticationException");
        String message = this.i18nUtility.getMessage("authentication.authenticate.user.invalid.password.exception", null);
        throw new BadRequestException(message);
    }
}

