/*
 * Decompiled with CFR 0.152.
 */
package com.upl.depotdashboard.service.impl;

import com.upl.depotdashboard.domain.AppUser;
import com.upl.depotdashboard.repository.AppUserRepository;
import com.upl.depotdashboard.service.AppUserService;
import com.upl.depotdashboard.service.dto.AppUserDTO;
import com.upl.depotdashboard.service.exception.BadRequestException;
import com.upl.depotdashboard.service.mapper.AppUserMapper;
import com.upl.depotdashboard.service.utility.AmazonUtility;
import com.upl.depotdashboard.service.utility.I18nUtility;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(noRollbackFor={InterruptedException.class, ExecutionException.class})
public class AppUserServiceImpl
implements AppUserService {
    private final Logger log = LoggerFactory.getLogger(AppUserServiceImpl.class);
    private final AppUserRepository appUserRepository;
    private final AppUserMapper appUserMapper;
    @Autowired
    private PasswordEncoder passwordEncoder;
    private static final String UPLOAD_DIRECTORY = "appUsers";
    @Value(value="${application.allowed-image-content-types:}")
    private String allowedImageContentTypes;
    @Autowired
    private AmazonUtility amazonUtility;
    @Autowired
    private I18nUtility i18nUtility;

    public AppUserServiceImpl(AppUserRepository appUserRepository, AppUserMapper appUserMapper) {
        this.appUserRepository = appUserRepository;
        this.appUserMapper = appUserMapper;
    }

    public AppUserDTO save(AppUserDTO appUserDTO) {
        Optional appUserExistWithEmail;
        this.log.debug("Request to save AppUser : {}", (Object)appUserDTO);
        if (appUserDTO.getEmail() != null && (appUserExistWithEmail = this.appUserRepository.findByEmail(appUserDTO.getEmail())).isPresent() && !((AppUser)appUserExistWithEmail.get()).getId().equals(appUserDTO.getId())) {
            this.log.debug("User already exist with email.");
            String message = this.i18nUtility.getMessage("appuser.save.email.exception", null);
            throw new BadRequestException(message);
        }
        Optional appUserExistWithMobile = this.appUserRepository.findByMobileNumber(appUserDTO.getMobileNumber());
        if (appUserExistWithMobile.isPresent() && !((AppUser)appUserExistWithMobile.get()).getId().equals(appUserDTO.getId())) {
            this.log.debug("User already exist with mobile number.");
            String message = this.i18nUtility.getMessage("appuser.save.mobile.number.exception", null);
            throw new BadRequestException(message);
        }
        AppUser appUser = this.appUserMapper.toEntity(appUserDTO);
        appUser.setFullName(appUser.getFirstName() + " " + appUser.getLastName());
        this.log.debug("encode user password");
        if (appUser.getId() == null) {
            appUser.setPassword(this.passwordEncoder.encode((CharSequence)appUser.getPassword()));
        } else {
            Optional existingUser = this.appUserRepository.findById((Object)appUser.getId());
            if (existingUser.isPresent()) {
                appUser.setPassword(((AppUser)existingUser.get()).getPassword());
            } else {
                appUser.setPassword(this.passwordEncoder.encode((CharSequence)appUser.getPassword()));
            }
        }
        AppUser result = (AppUser)this.appUserRepository.save((Object)appUser);
        return this.appUserMapper.toDto(result);
    }

    public AppUserDTO uploadAndSaveProfileImage(Long id, MultipartFile file) throws IOException {
        String[] elements = this.allowedImageContentTypes.split(",");
        List<String> allowedTypes = Arrays.asList(elements);
        if (allowedTypes.contains(file.getContentType())) {
            Optional appUser = this.appUserRepository.findById((Object)id);
            if (StringUtils.isNotBlank((CharSequence)((AppUser)appUser.get()).getProfilePhotoPath())) {
                this.amazonUtility.deleteFileFromS3Bucket(((AppUser)appUser.get()).getProfilePhotoPath());
            }
            String url = this.amazonUtility.uploadFile(file, "appUsers/" + id);
            ((AppUser)appUser.get()).setProfilePhotoPath(url);
            AppUser savedAppUser = (AppUser)this.appUserRepository.save((Object)((AppUser)appUser.get()));
            return this.appUserMapper.toDto(savedAppUser);
        }
        String message = this.i18nUtility.getMessage("appuser.upload.image.exception", null);
        throw new BadRequestException(message);
    }

    @Transactional(readOnly=true)
    public Page<AppUserDTO> findAll(Pageable pageable) {
        this.log.debug("Request to get all AppUsers");
        return this.appUserRepository.findAll(pageable).map(arg_0 -> ((AppUserMapper)this.appUserMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public Optional<AppUserDTO> findOne(Long id) {
        this.log.debug("Request to get AppUser : {}", (Object)id);
        return this.appUserRepository.findById((Object)id).map(arg_0 -> ((AppUserMapper)this.appUserMapper).toDto(arg_0));
    }

    public void delete(Long id) {
        try {
            this.log.debug("Request to delete AppUser : {}", (Object)id);
            this.appUserRepository.deleteById((Object)id);
        }
        catch (Exception e) {
            this.log.debug("User not exist with ID :" + id);
            String message = this.i18nUtility.getMessage("appuser.delete.id.exception", null);
            throw new BadRequestException(message);
        }
    }
}

