/*
 * Decompiled with CFR 0.152.
 */
package com.upl.depotdashboard.service.impl;

import com.upl.depotdashboard.domain.AppUserLogin;
import com.upl.depotdashboard.repository.AppUserLoginRepository;
import com.upl.depotdashboard.service.AppUserLoginService;
import com.upl.depotdashboard.service.dto.AppUserLoginDTO;
import com.upl.depotdashboard.service.mapper.AppUserLoginMapper;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AppUserLoginServiceImpl
implements AppUserLoginService {
    private final Logger log = LoggerFactory.getLogger(AppUserLoginServiceImpl.class);
    private final AppUserLoginRepository appUserLoginRepository;
    private final AppUserLoginMapper appUserLoginMapper;

    public AppUserLoginServiceImpl(AppUserLoginRepository appUserLoginRepository, AppUserLoginMapper appUserLoginMapper) {
        this.appUserLoginRepository = appUserLoginRepository;
        this.appUserLoginMapper = appUserLoginMapper;
    }

    public AppUserLoginDTO save(AppUserLoginDTO appUserLoginDTO) {
        this.log.debug("Request to save AppUserLogin : {}", (Object)appUserLoginDTO);
        AppUserLogin appUserLogin = (AppUserLogin)this.appUserLoginMapper.toEntity((Object)appUserLoginDTO);
        appUserLogin = (AppUserLogin)this.appUserLoginRepository.save((Object)appUserLogin);
        return (AppUserLoginDTO)this.appUserLoginMapper.toDto((Object)appUserLogin);
    }

    @Transactional(readOnly=true)
    public List<AppUserLoginDTO> findAll() {
        this.log.debug("Request to get all AppUserLogins");
        return this.appUserLoginRepository.findAll().stream().map(arg_0 -> ((AppUserLoginMapper)this.appUserLoginMapper).toDto(arg_0)).collect(Collectors.toCollection(LinkedList::new));
    }

    @Transactional(readOnly=true)
    public Optional<AppUserLoginDTO> findOne(Long id) {
        this.log.debug("Request to get AppUserLogin : {}", (Object)id);
        return this.appUserLoginRepository.findById((Object)id).map(arg_0 -> ((AppUserLoginMapper)this.appUserLoginMapper).toDto(arg_0));
    }

    public void delete(Long id) {
        this.log.debug("Request to delete AppUserLogin : {}", (Object)id);
        this.appUserLoginRepository.deleteById((Object)id);
    }

    @Transactional(readOnly=true)
    public Optional<AppUserLoginDTO> findByToken(String token) {
        this.log.debug("Request to get AppUserLogin : {}", (Object)token);
        return this.appUserLoginRepository.findByToken(token).map(arg_0 -> ((AppUserLoginMapper)this.appUserLoginMapper).toDto(arg_0));
    }
}

