/*
 * Decompiled with CFR 0.152.
 */
package com.upl.depotdashboard.service;

import com.upl.depotdashboard.domain.PlantProfitCenter;
import com.upl.depotdashboard.domain.PlantProfitCenter_;
import com.upl.depotdashboard.repository.PlantProfitCenterRepository;
import com.upl.depotdashboard.service.criteria.PlantProfitCenterCriteria;
import com.upl.depotdashboard.service.dto.PlantProfitCenterDTO;
import com.upl.depotdashboard.service.mapper.PlantProfitCenterMapper;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tech.jhipster.service.QueryService;
import tech.jhipster.service.filter.Filter;
import tech.jhipster.service.filter.RangeFilter;

@Service
@Transactional(readOnly=true)
public class PlantProfitCenterQueryService
extends QueryService<PlantProfitCenter> {
    private final Logger log = LoggerFactory.getLogger(PlantProfitCenterQueryService.class);
    private final PlantProfitCenterRepository plantProfitCenterRepository;
    private final PlantProfitCenterMapper plantProfitCenterMapper;

    public PlantProfitCenterQueryService(PlantProfitCenterRepository plantProfitCenterRepository, PlantProfitCenterMapper plantProfitCenterMapper) {
        this.plantProfitCenterRepository = plantProfitCenterRepository;
        this.plantProfitCenterMapper = plantProfitCenterMapper;
    }

    @Transactional(readOnly=true)
    public List<PlantProfitCenterDTO> findByCriteria(PlantProfitCenterCriteria criteria) {
        this.log.debug("find by criteria : {}", (Object)criteria);
        Specification specification = this.createSpecification(criteria);
        return this.plantProfitCenterMapper.toDto(this.plantProfitCenterRepository.findAll(specification));
    }

    @Transactional(readOnly=true)
    public Page<PlantProfitCenterDTO> findByCriteria(PlantProfitCenterCriteria criteria, Pageable page) {
        this.log.debug("find by criteria : {}, page: {}", (Object)criteria, (Object)page);
        Specification specification = this.createSpecification(criteria);
        return this.plantProfitCenterRepository.findAll(specification, page).map(arg_0 -> ((PlantProfitCenterMapper)this.plantProfitCenterMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public long countByCriteria(PlantProfitCenterCriteria criteria) {
        this.log.debug("count by criteria : {}", (Object)criteria);
        Specification specification = this.createSpecification(criteria);
        return this.plantProfitCenterRepository.count(specification);
    }

    protected Specification<PlantProfitCenter> createSpecification(PlantProfitCenterCriteria criteria) {
        Specification specification = Specification.where(null);
        if (criteria != null) {
            if (criteria.getDistinct() != null) {
                specification = specification.and(this.distinct(criteria.getDistinct().booleanValue()));
            }
            if (criteria.getId() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getId(), PlantProfitCenter_.id));
            }
            if (criteria.getPlantName() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getPlantName(), PlantProfitCenter_.plantName));
            }
            if (criteria.getCompanyName() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getCompanyName(), PlantProfitCenter_.companyName));
            }
            if (criteria.getCompanyLocation() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getCompanyLocation(), PlantProfitCenter_.companyLocation));
            }
            if (criteria.getBillDocumentNumber() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getBillDocumentNumber(), PlantProfitCenter_.billDocumentNumber));
            }
            if (criteria.getBillCreatedOn() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getBillCreatedOn(), PlantProfitCenter_.billCreatedOn));
            }
            if (criteria.getBillCreatedTime() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getBillCreatedTime(), PlantProfitCenter_.billCreatedTime));
            }
            if (criteria.getDeliveryNumber() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getDeliveryNumber(), PlantProfitCenter_.deliveryNumber));
            }
            if (criteria.getDeliveryOn() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getDeliveryOn(), PlantProfitCenter_.deliveryOn));
            }
            if (criteria.getDeliveryTime() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getDeliveryTime(), PlantProfitCenter_.deliveryTime));
            }
            if (criteria.getDocumentDate() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getDocumentDate(), PlantProfitCenter_.documentDate));
            }
            if (criteria.getDocumentEntryTime() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getDocumentEntryTime(), PlantProfitCenter_.documentEntryTime));
            }
            if (criteria.getDocumentScanStatus() != null) {
                specification = specification.and(this.buildSpecification((Filter)criteria.getDocumentScanStatus(), PlantProfitCenter_.documentScanStatus));
            }
            if (criteria.getDocumentScannedOn() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getDocumentScannedOn(), PlantProfitCenter_.documentScannedOn));
            }
            if (criteria.getDocumentScannedAt() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getDocumentScannedAt(), PlantProfitCenter_.documentScannedAt));
            }
            if (criteria.getPlantIndicator() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getPlantIndicator(), PlantProfitCenter_.plantIndicator));
            }
            if (criteria.getSalesOrgnisation() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getSalesOrgnisation(), PlantProfitCenter_.salesOrgnisation));
            }
            if (criteria.getDistributionChannelId() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getDistributionChannelId(), PlantProfitCenter_.distributionChannelId));
            }
            if (criteria.getDistributionChannelName() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getDistributionChannelName(), PlantProfitCenter_.distributionChannelName));
            }
            if (criteria.getDivisionCode() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getDivisionCode(), PlantProfitCenter_.divisionCode));
            }
            if (criteria.getTargetCode() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getTargetCode(), PlantProfitCenter_.targetCode));
            }
            if (criteria.getTargetRetailerName() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getTargetRetailerName(), PlantProfitCenter_.targetRetailerName));
            }
            if (criteria.getBillType() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getBillType(), PlantProfitCenter_.billType));
            }
            if (criteria.getBillDate() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getBillDate(), PlantProfitCenter_.billDate));
            }
        }
        return specification;
    }
}

