/*
 * Decompiled with CFR 0.152.
 */
package com.upl.depotdashboard.repository;

import com.upl.depotdashboard.domain.CountWithDatesView;
import com.upl.depotdashboard.domain.DepotOBDCountView;
import com.upl.depotdashboard.domain.PlantProfitCenter;
import com.upl.depotdashboard.domain.ScannedUnscannedCountWithDatesView;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface PlantProfitCenterRepository
extends JpaRepository<PlantProfitCenter, Long>,
JpaSpecificationExecutor<PlantProfitCenter> {
    @Query(value="WITH Numbers AS (SELECT ROW_NUMBER() OVER () AS RN FROM countries LIMIT 30)\nSELECT startDate, endDate, (CASE WHEN sum(c) IS NULL THEN 0 ELSE sum(c) END) AS count\nFROM (SELECT DATE_ADD(:startDate, INTERVAL Numbers.RN - 1 WEEK) AS startDate,\n             (CASE\n                  WHEN DATE_ADD(:startDate, INTERVAL Numbers.RN WEEK) < :endDate\n                      THEN DATE_ADD(:startDate, INTERVAL Numbers.RN WEEK)\n                  ELSE :endDate END) AS endDate\n      FROM countries\n               cross join Numbers\n      where DATE_ADD(:startDate, INTERVAL Numbers.RN - 1 WEEK) < :endDate\n      group by startDate, endDate\n      order by startDate) t\n         left join\n     (SELECT bill_created_on, COUNT(*) AS c\n      FROM plant_profit_centers\n      WHERE (CASE\n                 WHEN :companyName IS NOT NULL THEN company_name = :companyName\n                 ELSE document_scan_status = :status END)\n        AND (CASE\n                 WHEN :cAvail THEN company_location IN :companyLocation\n                 ELSE document_scan_status = :status END)\n        AND (CASE WHEN :sAvail THEN sbu_name IN :sbuName ELSE document_scan_status = :status END)\n        AND bill_created_on BETWEEN :startDate AND :endDate\n      group by bill_created_on) dd\n     on dd.bill_created_on >= t.startDate and dd.bill_created_on < t.endDate\ngroup by startDate, endDate\norder by startDate", nativeQuery=true)
    public List<CountWithDatesView> countByMonth(@Param(value="companyName") String var1, @Param(value="companyLocation") List<String> var2, @Param(value="sbuName") List<String> var3, @Param(value="startDate") String var4, @Param(value="endDate") String var5, @Param(value="status") Boolean var6, @Param(value="cAvail") Boolean var7, @Param(value="sAvail") Boolean var8);

    @Query(value="SELECT COUNT(*) FROM plant_profit_centers", nativeQuery=true)
    public Float countOfTotal();

    @Query(value="WITH Numbers AS (SELECT ROW_NUMBER() over () AS RN FROM countries LIMIT 30)\nSELECT startDate, endDate, (CASE WHEN sum(c) IS NULL THEN 0 ELSE sum(c) END) AS count\nFROM (SELECT DATE_ADD(:startDate, INTERVAL Numbers.RN - 1 WEEK) AS startDate,\n             (CASE\n                  WHEN DATE_ADD(:startDate, INTERVAL Numbers.RN WEEK) < :endDate\n                      THEN DATE_ADD(:startDate, INTERVAL Numbers.RN WEEK)\n                  ELSE :endDate END)                            as endDate\n      FROM countries\n               cross join Numbers\n      where DATE_ADD(:startDate, INTERVAL Numbers.RN - 1 WEEK) < :endDate\n      group by startDate, endDate\n      order by startDate) t\n         left join\n     (SELECT bill_created_on, COUNT(*) AS c\n      FROM plant_profit_centers\n      WHERE (CASE\n                 WHEN :companyName IS NOT NULL THEN company_name = :companyName\n                 ELSE document_scan_status = :status END)\n        AND (CASE\n                 WHEN :cAvail THEN company_location IN :companyLocation\n                 ELSE document_scan_status = :status END)\n        AND (CASE WHEN :sAvail THEN sbu_name IN :sbuName ELSE document_scan_status = :status END)\n        AND document_scanned_on IS NOT NULL\n        AND bill_created_on BETWEEN :startDate AND :endDate\n      group by bill_created_on) dd\n     on dd.bill_created_on >= t.startDate and dd.bill_created_on < t.endDate\ngroup by startDate, endDate\norder by startDate", nativeQuery=true)
    public List<CountWithDatesView> countByTotalScanned(@Param(value="companyName") String var1, @Param(value="companyLocation") List<String> var2, @Param(value="sbuName") List<String> var3, @Param(value="startDate") String var4, @Param(value="endDate") String var5, @Param(value="status") Boolean var6, @Param(value="cAvail") Boolean var7, @Param(value="sAvail") Boolean var8);

    @Query(value="WITH Numbers AS (SELECT ROW_NUMBER() over () AS RN FROM countries LIMIT 30)\nSELECT startDate, endDate, (CASE WHEN sum(c) IS NULL THEN 0 ELSE sum(c) END) AS count\nFROM (SELECT DATE_ADD(:startDate, INTERVAL Numbers.RN - 1 WEEK) AS startDate,\n             (CASE\n                  WHEN DATE_ADD(:startDate, INTERVAL Numbers.RN WEEK) < :endDate\n                      THEN DATE_ADD(:startDate, INTERVAL Numbers.RN WEEK)\n                  ELSE :endDate END)                            as endDate\n      FROM countries\n               cross join Numbers\n      where DATE_ADD(:startDate, INTERVAL Numbers.RN - 1 WEEK) < :endDate\n      group by startDate, endDate\n      order by startDate) t\n         left join\n     (SELECT bill_created_on, COUNT(*) AS c\n      FROM plant_profit_centers\n      WHERE (CASE\n                 WHEN :companyName IS NOT NULL THEN company_name = :companyName\n                 ELSE document_scan_status = :status END)\n        AND (CASE\n                 WHEN :cAvail THEN company_location IN :companyLocation\n                 ELSE document_scan_status = :status END)\n        AND (CASE WHEN :sAvail IS NOT NULL THEN sbu_name IN :sbuName ELSE document_scan_status = :status END)\n        AND document_scanned_on IS NULL\n        AND bill_created_on BETWEEN :startDate AND :endDate\n      group by bill_created_on) dd\n     on dd.bill_created_on >= t.startDate and dd.bill_created_on < t.endDate\ngroup by startDate, endDate\norder by startDate", nativeQuery=true)
    public List<CountWithDatesView> countByTotalUnscanned(@Param(value="companyName") String var1, @Param(value="companyLocation") List<String> var2, @Param(value="sbuName") List<String> var3, @Param(value="startDate") String var4, @Param(value="endDate") String var5, @Param(value="status") Boolean var6, @Param(value="cAvail") Boolean var7, @Param(value="sAvail") Boolean var8);

    @Query(value="SELECT sum(scanned_count) AS scanned_count,sum(unscanned_count) AS unscanned_count FROM (\nSELECT 0 AS scanned_count, COUNT(*) AS unscanned_count,company_name, company_location FROM plant_profit_centers WHERE (CASE WHEN :companyName IS NOT NULL THEN company_name=:companyName ELSE document_scan_status =:status END) AND (CASE WHEN :cAvail THEN company_location in :companyLocation ELSE document_scan_status =:status END) AND (CASE WHEN :sAvail THEN sbu_name in :sbuName ELSE document_scan_status =:status END) AND document_scanned_on IS NULL AND bill_created_on BETWEEN :startDate AND :endDate\nUNION\nSELECT COUNT(*) AS scanned_count, 0 AS unscanned_count,company_name, company_location FROM plant_profit_centers WHERE (CASE WHEN :companyName IS NOT NULL THEN company_name=:companyName ELSE document_scan_status =:status END) AND (CASE WHEN :cAvail THEN company_location in :companyLocation ELSE document_scan_status =:status END) AND (CASE WHEN :sAvail THEN sbu_name in :sbuName ELSE document_scan_status =:status END) AND document_scanned_on IS NOT NULL AND bill_created_on BETWEEN :startDate AND :endDate)\ntemp", nativeQuery=true)
    public List<Object[]> countByTotalScannedAndUnscanned(@Param(value="companyName") String var1, @Param(value="companyLocation") List<String> var2, @Param(value="sbuName") List<String> var3, @Param(value="startDate") String var4, @Param(value="endDate") String var5, @Param(value="status") Boolean var6, @Param(value="cAvail") Boolean var7, @Param(value="sAvail") Boolean var8);

    @Query(value="SELECT company_location as companyLocation,sum(scanned_count) AS scannedCount,sum(unscanned_count) AS unscannedCount,company_name as companyName FROM (\nSELECT 0 AS scanned_count, COUNT(*) AS unscanned_count,company_name, company_location FROM plant_profit_centers WHERE (CASE WHEN :companyName IS NOT NULL THEN company_name=:companyName ELSE document_scan_status =:status END) AND (CASE WHEN :cAvail THEN company_location in :companyLocation ELSE document_scan_status =:status END) AND (CASE WHEN :sAvail THEN sbu_name in :sbuName ELSE document_scan_status =:status END) AND document_scanned_on IS NULL AND bill_created_on BETWEEN :startDate AND :endDate GROUP BY company_name,company_location\nUNION\nSELECT COUNT(*) AS scanned_count, 0 AS unscanned_count,company_name, company_location FROM plant_profit_centers WHERE (CASE WHEN :companyName IS NOT NULL THEN company_name=:companyName ELSE document_scan_status =:status END) AND (CASE WHEN :cAvail THEN company_location in :companyLocation ELSE document_scan_status =:status END) AND (CASE WHEN :sAvail THEN sbu_name in :sbuName ELSE document_scan_status =:status END) AND document_scanned_on IS NOT NULL AND bill_created_on BETWEEN :startDate AND :endDate GROUP BY company_name,company_location) temp GROUP BY company_name,company_location;\n", nativeQuery=true)
    public List<DepotOBDCountView> getDepotOBDCount(@Param(value="companyName") String var1, @Param(value="companyLocation") List<String> var2, @Param(value="sbuName") List<String> var3, @Param(value="startDate") String var4, @Param(value="endDate") String var5, @Param(value="status") Boolean var6, @Param(value="cAvail") Boolean var7, @Param(value="sAvail") Boolean var8);

    @Query(value="with Numbers as (select ROW_NUMBER() over () as rn from countries limit 10)\nselect startDate, endDate, (CASE WHEN sum(sc) IS NULL THEN 0 ELSE sum(sc) END ) AS scannedCount, (CASE WHEN sum(usc) IS NULL THEN 0 ELSE sum(usc) END ) AS unscannedCount\nfrom (select DATE_ADD(:startDate, INTERVAL Numbers.rn - 1 WEEK) as startDate,\n             (CASE\n                  WHEN DATE_ADD(:startDate, INTERVAL Numbers.rn WEEK) < :endDate\n                      THEN DATE_ADD(:startDate, INTERVAL Numbers.rn WEEK)\n                  ELSE :endDate END)                            as endDate\n      from countries\n               cross join Numbers\n      where DATE_ADD(:startDate, INTERVAL Numbers.rn - 1 WEEK) < :endDate\n      group by startDate, endDate\n      order by startDate) t\n         left join (SELECT sum(scanned_count) AS sc, sum(unscanned_count) AS usc, bill_created_on\n                    FROM (\n                             SELECT 0 AS scanned_count, COUNT(*) AS unscanned_count, bill_created_on\n                             FROM plant_profit_centers\n                             WHERE (CASE\n                                        WHEN :companyName IS NOT NULL THEN company_name = :companyName\n                                        ELSE document_scan_status = :status END)\n                               AND (CASE\n                                        WHEN :cAvail THEN company_location in :companyLocation\n                                        ELSE document_scan_status = :status END)\n                               AND (CASE WHEN :sAvail THEN sbu_name in :sbuName ELSE document_scan_status = :status END)\n                               AND document_scanned_on IS NULL\n                               AND bill_created_on BETWEEN :startDate AND :endDate\n                             group by bill_created_on\n                             UNION\n                             SELECT COUNT(*) AS scanned_count, 0 AS unscanned_count, bill_created_on\n                             FROM plant_profit_centers\n                             WHERE (CASE\n                                        WHEN :companyName IS NOT NULL THEN company_name = :companyName\n                                        ELSE document_scan_status = :status END)\n                               AND (CASE\n                                        WHEN :cAvail THEN company_location in :companyLocation\n                                        ELSE document_scan_status = :status END)\n                               AND (CASE WHEN :sAvail THEN sbu_name in :sbuName ELSE document_scan_status = :status END)\n                               AND document_scanned_on IS NOT NULL\n                               AND bill_created_on BETWEEN :startDate AND :endDate\n                             group by bill_created_on\n                         ) temp\n                    group by bill_created_on\n                    order by bill_created_on\n                   ) dd\n                   on dd.bill_created_on >= t.startDate AND dd.bill_created_on < t.endDate\ngroup by startDate, endDate", nativeQuery=true)
    public List<ScannedUnscannedCountWithDatesView> getGetCountByWeek(@Param(value="companyName") String var1, @Param(value="companyLocation") List<String> var2, @Param(value="sbuName") List<String> var3, @Param(value="startDate") String var4, @Param(value="endDate") String var5, @Param(value="status") Boolean var6, @Param(value="cAvail") Boolean var7, @Param(value="sAvail") Boolean var8);

    @Query(value="SELECT company_name,COUNT(*) AS scanned_count FROM plant_profit_centers WHERE (CASE WHEN :companyName IS NOT NULL THEN company_name=:companyName ELSE document_scan_status =:status END) AND (CASE WHEN :cAvail THEN company_location in :companyLocation ELSE document_scan_status =:status END) AND (CASE WHEN :sAvail THEN sbu_name in :sbuName ELSE document_scan_status =:status END) AND document_scanned_on IS NOT NULL AND bill_created_on BETWEEN :startDate AND :endDate GROUP BY company_name\t", nativeQuery=true)
    public List<Object[]> getOverallScannedForProfitCenter(@Param(value="companyName") String var1, @Param(value="companyLocation") List<String> var2, @Param(value="sbuName") List<String> var3, @Param(value="startDate") String var4, @Param(value="endDate") String var5, @Param(value="status") Boolean var6, @Param(value="cAvail") Boolean var7, @Param(value="sAvail") Boolean var8);

    @Query(value="SELECT company_name,COUNT(*) AS unscanned_count FROM plant_profit_centers WHERE (CASE WHEN :companyName IS NOT NULL THEN company_name=:companyName ELSE document_scan_status =:status END) AND (CASE WHEN :cAvail THEN company_location in :companyLocation ELSE document_scan_status =:status END) AND (CASE WHEN :sAvail THEN sbu_name in :sbuName ELSE document_scan_status =:status END) AND document_scanned_on IS NULL AND bill_created_on BETWEEN :startDate AND :endDate GROUP BY company_name", nativeQuery=true)
    public List<Object[]> getOverallUnscannedForProfitCenter(@Param(value="companyName") String var1, @Param(value="companyLocation") List<String> var2, @Param(value="sbuName") List<String> var3, @Param(value="startDate") String var4, @Param(value="endDate") String var5, @Param(value="status") Boolean var6, @Param(value="cAvail") Boolean var7, @Param(value="sAvail") Boolean var8);

    @Query(value="with Numbers as (select ROW_NUMBER() over () as rn from countries limit 10)\nSELECT startDate,endDate,(CASE WHEN sum(sc) IS NULL THEN 0 ELSE sum(sc) END) AS scannedCount,(CASE WHEN sum(usc) IS NULL THEN 0 ELSE sum(usc) END) AS unscannedCount FROM\n(select DATE_ADD(:startDate, INTERVAL Numbers.rn - 1 WEEK) as startDate,\n       (CASE\n            WHEN DATE_ADD(:startDate, INTERVAL Numbers.rn WEEK) < :endDate\n                THEN DATE_ADD(:startDate, INTERVAL Numbers.rn WEEK)\n            ELSE :endDate END)                            as endDate\nfrom countries\n         cross join Numbers\nwhere DATE_ADD(:startDate, INTERVAL Numbers.rn - 1 WEEK) < :endDate\ngroup by startDate, endDate\norder by startDate) t\nleft join\n(SELECT SUM(scanned_count) AS sc, SUM(unscanned_count) AS usc, bill_created_on\nFROM (\n         SELECT 0 AS scanned_count, COUNT(*) AS unscanned_count, bill_created_on\n         FROM plant_profit_centers\n         WHERE (CASE\n                    WHEN :companyName IS NOT NULL THEN company_name = :companyName\n                    ELSE document_scan_status = :status END)\n           AND (CASE WHEN :cAvail THEN company_location in :companyLocation ELSE document_scan_status = :status END)\n           AND (CASE WHEN :sAvail THEN sbu_name in :sbuName ELSE document_scan_status = :status END)\n           AND document_scanned_on IS NULL\n           AND bill_created_on BETWEEN :startDate AND :endDate\n         GROUP BY bill_created_on\n         UNION\n         SELECT COUNT(*) AS scanned_count, 0 AS unscanned_count, bill_created_on\n         FROM plant_profit_centers\n         WHERE (CASE\n                    WHEN :companyName IS NOT NULL THEN company_name = :companyName\n                    ELSE document_scan_status = :status END)\n           AND (CASE WHEN :cAvail THEN company_location in :companyLocation ELSE document_scan_status = :status END)\n           AND (CASE WHEN :sAvail THEN sbu_name in :sbuName ELSE document_scan_status = :status END)\n           AND document_scanned_on IS NOT NULL\n           AND bill_created_on BETWEEN :startDate AND :endDate\n         GROUP BY bill_created_on) temp\n    GROUP BY bill_created_on) dd\non dd.bill_created_on >= t.startDate AND dd.bill_created_on < t.endDate\ngroup by startDate, endDate\norder by startDate", nativeQuery=true)
    public List<ScannedUnscannedCountWithDatesView> getOBDCountForProfitCenter(@Param(value="companyName") String var1, @Param(value="companyLocation") List<String> var2, @Param(value="sbuName") List<String> var3, @Param(value="startDate") String var4, @Param(value="endDate") String var5, @Param(value="status") Boolean var6, @Param(value="cAvail") Boolean var7, @Param(value="sAvail") Boolean var8);

    @Query(value="SELECT company_name,company_location,sum(scanned_count + unscanned_count) as total_count,sum(scanned_count) AS scanned_count,sum(unscanned_count) AS unscanned_count,sbu_name FROM (\nSELECT 0 AS scanned_count,COUNT(*) AS unscanned_count,company_name ,company_location,sbu_name FROM plant_profit_centers \nWHERE (CASE WHEN :companyName IS NOT NULL THEN company_name=:companyName ELSE document_scan_status =:status END) AND\n(CASE WHEN :cAvail THEN company_location in :companyLocation ELSE document_scan_status =:status END) AND \n(CASE WHEN :sAvail THEN sbu_name in :sbuName ELSE document_scan_status =:status END) AND \n(company_name LIKE %:query% or company_location like %:query% or sbu_name like %:query%) AND\ndocument_scanned_on IS NULL AND bill_created_on BETWEEN :startDate AND :endDate GROUP BY company_location,company_name,sbu_name\nUNION\nSELECT COUNT(*) AS scanned_count,0 AS unscanned_count, company_name,company_location,sbu_name FROM plant_profit_centers \nWHERE (CASE WHEN :companyName IS NOT NULL THEN company_name=:companyName ELSE document_scan_status =:status END) AND\n(CASE WHEN :cAvail THEN company_location in :companyLocation ELSE document_scan_status =:status END) AND \n(CASE WHEN :sAvail THEN sbu_name in :sbuName ELSE document_scan_status =:status END) AND\n(company_name LIKE %:query% or company_location like %:query% or sbu_name like %:query%) AND\ndocument_scanned_on IS NOT NULL AND bill_created_on BETWEEN :startDate AND :endDate GROUP BY company_location,company_name,sbu_name) temp GROUP BY company_location,company_name,sbu_name;\n", nativeQuery=true)
    public List<Object[]> getTotalOBDForProfitCenter(@Param(value="companyName") String var1, @Param(value="companyLocation") List<String> var2, @Param(value="sbuName") List<String> var3, @Param(value="startDate") String var4, @Param(value="endDate") String var5, @Param(value="query") String var6, @Param(value="status") Boolean var7, @Param(value="cAvail") Boolean var8, @Param(value="sAvail") Boolean var9);

    @Query(value="SELECT sum(scanned_count + unscanned_count) as total_count,sum(scanned_count) AS scanned_count FROM (\nSELECT 0 AS scanned_count,COUNT(*) AS unscanned_count FROM plant_profit_centers WHERE (CASE WHEN :companyName IS NOT NULL THEN company_name=:companyName ELSE document_scan_status =:status END) AND (CASE WHEN :cAvail THEN company_location in :companyLocation ELSE document_scan_status =:status END) AND (CASE WHEN :sAvail THEN sbu_name in :sbuName ELSE document_scan_status =:status END) AND document_scanned_on IS NULL AND bill_created_on BETWEEN :startDate AND :endDate\nUNION\nSELECT COUNT(*) AS scanned_count,0 AS unscanned_count FROM plant_profit_centers WHERE (CASE WHEN :companyName IS NOT NULL THEN company_name=:companyName ELSE document_scan_status =:status END) AND (CASE WHEN :cAvail THEN company_location in :companyLocation ELSE document_scan_status =:status END) AND (CASE WHEN :sAvail THEN sbu_name in :sbuName ELSE document_scan_status =:status END) AND document_scanned_on IS NOT NULL AND bill_created_on BETWEEN :startDate AND :endDate) temp ;\n", nativeQuery=true)
    public List<Object[]> getScannedAndTotalCountForProfitCenter(@Param(value="companyName") String var1, @Param(value="companyLocation") List<String> var2, @Param(value="sbuName") List<String> var3, @Param(value="startDate") String var4, @Param(value="endDate") String var5, @Param(value="status") Boolean var6, @Param(value="cAvail") Boolean var7, @Param(value="sAvail") Boolean var8);

    @Query(value="SELECT company_location as companyLocation,sum(scanned_count) AS scannedCount,sum(unscanned_count) AS unscannedCount,company_name as companyName FROM (\nSELECT 0 AS scanned_count,COUNT(*) AS unscanned_count, company_location,company_name FROM plant_profit_centers \nWHERE (CASE WHEN :companyName IS NOT NULL THEN company_name=:companyName ELSE document_scan_status =:status END) AND (CASE WHEN :cAvail THEN company_location in :companyLocation ELSE document_scan_status =:status END) AND (CASE WHEN :sAvail THEN sbu_name in :sbuName ELSE document_scan_status =:status END) AND \ndocument_scanned_on IS NULL AND bill_created_on BETWEEN :startDate AND :endDate GROUP BY company_location,company_name\nUNION\nSELECT COUNT(*) AS scanned_count,0 AS unscanned_count, company_location,company_name FROM plant_profit_centers \nWHERE (CASE WHEN :companyName IS NOT NULL THEN company_name=:companyName ELSE document_scan_status =:status END) AND (CASE WHEN :cAvail THEN company_location in :companyLocation ELSE document_scan_status =:status END) AND (CASE WHEN :sAvail THEN sbu_name in :sbuName ELSE document_scan_status =:status END) AND \ndocument_scanned_on IS NOT NULL AND bill_created_on BETWEEN :startDate AND :endDate GROUP BY company_location,company_name) temp GROUP BY company_location,company_name ORDER BY sum(scanned_count+unscanned_count) DESC LIMIT 5;", nativeQuery=true)
    public List<DepotOBDCountView> getTopFiveDepot(@Param(value="companyName") String var1, @Param(value="companyLocation") List<String> var2, @Param(value="sbuName") List<String> var3, @Param(value="startDate") String var4, @Param(value="endDate") String var5, @Param(value="status") Boolean var6, @Param(value="cAvail") Boolean var7, @Param(value="sAvail") Boolean var8);

    @Query(value="SELECT company_location as companyLocation,sum(scanned_count) AS scannedCount,sum(unscanned_count) AS unscannedCount,company_name as companyName FROM (\nSELECT 0 AS scanned_count,COUNT(*) AS unscanned_count, company_location,company_name FROM plant_profit_centers \nWHERE (CASE WHEN :companyName IS NOT NULL THEN company_name=:companyName ELSE document_scan_status =:status END) AND (CASE WHEN :cAvail THEN company_location in :companyLocation ELSE document_scan_status =:status END) AND (CASE WHEN :sAvail THEN sbu_name in :sbuName ELSE document_scan_status =:status END) AND \ndocument_scanned_on IS NULL AND bill_created_on BETWEEN :startDate AND :endDate GROUP BY company_location,company_name\nUNION\nSELECT COUNT(*) AS scanned_count,0 AS unscanned_count, company_location,company_name FROM plant_profit_centers \nWHERE (CASE WHEN :companyName IS NOT NULL THEN company_name=:companyName ELSE document_scan_status =:status END) AND (CASE WHEN :cAvail THEN company_location in :companyLocation ELSE document_scan_status =:status END) AND (CASE WHEN :sAvail THEN sbu_name in :sbuName ELSE document_scan_status =:status END) AND \ndocument_scanned_on IS NOT NULL AND bill_created_on BETWEEN :startDate AND :endDate GROUP BY company_location,company_name) temp GROUP BY company_location,company_name ORDER BY sum(scanned_count+unscanned_count) ASC LIMIT 5;", nativeQuery=true)
    public List<DepotOBDCountView> getBottomFiveDepot(@Param(value="companyName") String var1, @Param(value="companyLocation") List<String> var2, @Param(value="sbuName") List<String> var3, @Param(value="startDate") String var4, @Param(value="endDate") String var5, @Param(value="status") Boolean var6, @Param(value="cAvail") Boolean var7, @Param(value="sAvail") Boolean var8);

    @Query(value="with Numbers as (select ROW_NUMBER() over () as rn from countries limit 10)\n      select startDate, endDate, (CASE WHEN sum(sc) IS NULL THEN 0 ELSE sum(sc) END ) AS scannedCount, (CASE WHEN sum(usc) IS NULL THEN 0 ELSE sum(usc) END ) AS unscannedCount\nFROM (select DATE_ADD(:startDate, INTERVAL Numbers.rn - 1 WEEK) as startDate,\n             (CASE\n                  WHEN DATE_ADD(:startDate, INTERVAL Numbers.rn WEEK) < :endDate\n                      THEN DATE_ADD(:startDate, INTERVAL Numbers.rn WEEK)\n                  ELSE :endDate END)                            as endDate\n      from countries\n               cross join Numbers\n      where DATE_ADD(:startDate, INTERVAL Numbers.rn - 1 WEEK) < :endDate\n      group by startDate, endDate\n      order by startDate) t\n         left join\n     (SELECT sum(scanned_count) AS sc, sum(unscanned_count) AS usc, bill_created_on\n      FROM (\n               SELECT 0 AS scanned_count, COUNT(*) AS unscanned_count, bill_created_on\n               FROM plant_profit_centers\n               WHERE (CASE\n                          WHEN :cAvail THEN company_location in :companyLocation\n                          ELSE document_scan_status = :status END)\n                 AND (CASE WHEN :sAvail THEN sbu_name in :sbuName ELSE document_scan_status = :status END)\n                 AND document_scanned_on IS NULL\n                 AND company_name = :companyName\n                 AND bill_created_on BETWEEN :startDate AND :endDate\n               GROUP BY bill_created_on\n               UNION\n               SELECT COUNT(*) AS scanned_count, 0 AS unscanned_count, bill_created_on\n               FROM plant_profit_centers\n               WHERE (CASE\n                          WHEN :cAvail THEN company_location in :companyLocation\n                          ELSE document_scan_status = :status END)\n                 AND (CASE WHEN :sAvail THEN sbu_name in :sbuName ELSE document_scan_status = :status END)\n                 AND document_scanned_on IS NOT NULL\n                 AND company_name = :companyName\n                 AND bill_created_on BETWEEN :startDate AND :endDate\n               GROUP BY bill_created_on) temp\n           GROUP BY bill_created_on\n     ) dd on dd.bill_created_on >= t.startDate AND dd.bill_created_on < t.endDate\ngroup by startDate, endDate\norder by endDate\n", nativeQuery=true)
    public List<ScannedUnscannedCountWithDatesView> getSbuWiseScanning(@Param(value="companyName") String var1, @Param(value="companyLocation") List<String> var2, @Param(value="sbuName") List<String> var3, @Param(value="startDate") String var4, @Param(value="endDate") String var5, @Param(value="status") Boolean var6, @Param(value="cAvail") Boolean var7, @Param(value="sAvail") Boolean var8);

    @Query(value="SELECT DISTINCT company_name,sbu_name,company_location FROM plant_profit_centers GROUP BY company_name,sbu_name,company_location;\n\t", nativeQuery=true)
    public List<Object[]> getProfitCentersData();

    @Query(value="SELECT company_name,sum(scanned_count+unscanned_count) as total_count,sum(scanned_count) AS scanned_count,sum(unscanned_count) AS unscanned_count FROM ( \nSELECT 0 AS scanned_count,COUNT(*) AS unscanned_count,company_name FROM plant_profit_centers WHERE document_scanned_on IS NULL AND bill_created_on BETWEEN :startDate AND :endDate GROUP BY company_name\nUNION\nSELECT COUNT(*) AS scanned_count,0 AS unscanned_count,company_name FROM plant_profit_centers WHERE document_scanned_on IS NOT NULL AND bill_created_on BETWEEN :startDate AND :endDate GROUP BY company_name) temp GROUP BY company_name;", nativeQuery=true)
    public List<Object[]> getSummaryForProfitCenter(@Param(value="startDate") String var1, @Param(value="endDate") String var2);
}

