/*
 * Decompiled with CFR 0.152.
 */
package com.upl.depotdashboard.config.audit;

import com.upl.depotdashboard.config.audit.AsyncEntityAuditEventWriter;
import com.upl.depotdashboard.config.audit.EntityAuditAction;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

public class EntityAuditEventListener
extends AuditingEntityListener {
    private final Logger log = LoggerFactory.getLogger(EntityAuditEventListener.class);
    private static BeanFactory beanFactory;

    @PostPersist
    public void onPostCreate(Object target) {
        try {
            AsyncEntityAuditEventWriter asyncEntityAuditEventWriter = (AsyncEntityAuditEventWriter)beanFactory.getBean(AsyncEntityAuditEventWriter.class);
            asyncEntityAuditEventWriter.writeAuditEvent(target, EntityAuditAction.CREATE);
        }
        catch (NoSuchBeanDefinitionException e) {
            this.log.error("No bean found for AsyncEntityAuditEventWriter");
        }
        catch (Exception e) {
            this.log.error("Exception while persisting create audit entity {}", (Throwable)e);
        }
    }

    @PostUpdate
    public void onPostUpdate(Object target) {
        try {
            AsyncEntityAuditEventWriter asyncEntityAuditEventWriter = (AsyncEntityAuditEventWriter)beanFactory.getBean(AsyncEntityAuditEventWriter.class);
            asyncEntityAuditEventWriter.writeAuditEvent(target, EntityAuditAction.UPDATE);
        }
        catch (NoSuchBeanDefinitionException e) {
            this.log.error("No bean found for AsyncEntityAuditEventWriter");
        }
        catch (Exception e) {
            this.log.error("Exception while persisting update audit entity {}", (Throwable)e);
        }
    }

    @PostRemove
    public void onPostRemove(Object target) {
        try {
            AsyncEntityAuditEventWriter asyncEntityAuditEventWriter = (AsyncEntityAuditEventWriter)beanFactory.getBean(AsyncEntityAuditEventWriter.class);
            asyncEntityAuditEventWriter.writeAuditEvent(target, EntityAuditAction.DELETE);
        }
        catch (NoSuchBeanDefinitionException e) {
            this.log.error("No bean found for AsyncEntityAuditEventWriter");
        }
        catch (Exception e) {
            this.log.error("Exception while persisting delete audit entity {}", (Throwable)e);
        }
    }

    static void setBeanFactory(BeanFactory beanFactory) {
        EntityAuditEventListener.beanFactory = beanFactory;
    }
}

