/*
 * Decompiled with CFR 0.152.
 */
package com.upl.depotdashboard.config.audit;

import com.upl.depotdashboard.domain.PersistentAuditEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.boot.actuate.audit.AuditEvent;
import org.springframework.security.web.authentication.WebAuthenticationDetails;
import org.springframework.stereotype.Component;

@Component
public class AuditEventConverter {
    public List<AuditEvent> convertToAuditEvent(Iterable<PersistentAuditEvent> persistentAuditEvents) {
        if (persistentAuditEvents == null) {
            return Collections.emptyList();
        }
        ArrayList<AuditEvent> auditEvents = new ArrayList<AuditEvent>();
        for (PersistentAuditEvent persistentAuditEvent : persistentAuditEvents) {
            auditEvents.add(this.convertToAuditEvent(persistentAuditEvent));
        }
        return auditEvents;
    }

    public AuditEvent convertToAuditEvent(PersistentAuditEvent persistentAuditEvent) {
        if (persistentAuditEvent == null) {
            return null;
        }
        return new AuditEvent(persistentAuditEvent.getAuditEventDate(), persistentAuditEvent.getPrincipal(), persistentAuditEvent.getAuditEventType(), this.convertDataToObjects(persistentAuditEvent.getData()));
    }

    public Map<String, Object> convertDataToObjects(Map<String, String> data) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        if (data != null) {
            for (Map.Entry<String, String> entry : data.entrySet()) {
                results.put(entry.getKey(), entry.getValue());
            }
        }
        return results;
    }

    public Map<String, String> convertDataToStrings(Map<String, Object> data) {
        HashMap<String, String> results = new HashMap<String, String>();
        if (data != null) {
            for (Map.Entry<String, Object> entry : data.entrySet()) {
                if (entry.getValue() instanceof WebAuthenticationDetails) {
                    WebAuthenticationDetails authenticationDetails = (WebAuthenticationDetails)entry.getValue();
                    results.put("remoteAddress", authenticationDetails.getRemoteAddress());
                    results.put("sessionId", authenticationDetails.getSessionId());
                    continue;
                }
                results.put(entry.getKey(), Objects.toString(entry.getValue()));
            }
        }
        return results;
    }
}

