/*
 * Decompiled with CFR 0.152.
 */
package com.upl.depotdashboard.config.audit;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.upl.depotdashboard.config.audit.EntityAuditAction;
import com.upl.depotdashboard.domain.AbstractAuditingEntity;
import com.upl.depotdashboard.domain.EntityAuditEvent;
import com.upl.depotdashboard.repository.EntityAuditEventRepository;
import java.io.IOException;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class AsyncEntityAuditEventWriter {
    private final Logger log = LoggerFactory.getLogger(AsyncEntityAuditEventWriter.class);
    private final EntityAuditEventRepository auditingEntityRepository;
    private final ObjectMapper objectMapper;

    public AsyncEntityAuditEventWriter(EntityAuditEventRepository auditingEntityRepository, ObjectMapper objectMapper) {
        this.auditingEntityRepository = auditingEntityRepository;
        this.objectMapper = objectMapper;
    }

    @Async
    public void writeAuditEvent(Object target, EntityAuditAction action) {
        this.log.debug("-------------- Post {} audit  --------------", (Object)action.value());
        try {
            EntityAuditEvent auditedEntity = this.prepareAuditEntity(target, action);
            if (auditedEntity != null) {
                this.auditingEntityRepository.save((Object)auditedEntity);
            }
        }
        catch (Exception e) {
            this.log.error("Exception while persisting audit entity for {} error: {}", target, (Object)e);
        }
    }

    private EntityAuditEvent prepareAuditEntity(Object entity, EntityAuditAction action) {
        String entityData;
        Long entityId;
        EntityAuditEvent auditedEntity = new EntityAuditEvent();
        Class<?> entityClass = entity.getClass();
        auditedEntity.setAction(action.value());
        auditedEntity.setEntityType(entityClass.getName());
        this.log.trace("Getting Entity Id and Content");
        try {
            Field privateLongField = entityClass.getDeclaredField("id");
            privateLongField.setAccessible(true);
            entityId = (Long)privateLongField.get(entity);
            privateLongField.setAccessible(false);
            entityData = this.objectMapper.writeValueAsString(entity);
        }
        catch (IOException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            this.log.error("Exception while getting entity ID and content {}", (Throwable)e);
            return null;
        }
        auditedEntity.setEntityId(entityId);
        auditedEntity.setEntityValue(entityData);
        AbstractAuditingEntity abstractAuditEntity = (AbstractAuditingEntity)entity;
        if (EntityAuditAction.CREATE.equals((Object)action)) {
            auditedEntity.setModifiedBy(abstractAuditEntity.getCreatedBy());
            auditedEntity.setModifiedDate(abstractAuditEntity.getCreatedDate());
            auditedEntity.setCommitVersion(Integer.valueOf(1));
        } else {
            auditedEntity.setModifiedBy(abstractAuditEntity.getLastModifiedBy());
            auditedEntity.setModifiedDate(abstractAuditEntity.getLastModifiedDate());
            this.calculateVersion(auditedEntity);
        }
        this.log.trace("Audit Entity --> {} ", (Object)auditedEntity.toString());
        return auditedEntity;
    }

    private void calculateVersion(EntityAuditEvent auditedEntity) {
        this.log.trace("Version calculation. for update/remove");
        Integer lastCommitVersion = this.auditingEntityRepository.findMaxCommitVersion(auditedEntity.getEntityType(), auditedEntity.getEntityId());
        this.log.trace("Last commit version of entity => {}", (Object)lastCommitVersion);
        if (lastCommitVersion != null && lastCommitVersion != 0) {
            this.log.trace("Present. Adding version..");
            auditedEntity.setCommitVersion(Integer.valueOf(lastCommitVersion + 1));
        } else {
            this.log.trace("No entities.. Adding new version 1");
            auditedEntity.setCommitVersion(Integer.valueOf(1));
        }
    }
}

